/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.metrics;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VirtualMachineMetric {
    public long vmUpTime = -1L;
    public int availProcessors = -1;
    public long jitCompilationTime = -1L;
    public long totalMemory = -1L;
    public long freeMemory = -1L;
    public long loadedClassCount = -1L;
    public long unloadedClassCount = -1L;
    public long totalLoadedClassCount = -1L;
    public HashMap<String, List> memoryUsage = new HashMap();
    public HashMap<String, List> garbageCollector = new HashMap();

    public void recordData(long vmUpTime, int availProcessors, long jitCompilationTime, long totalMemory, long freeMemory, long loadedClassCount, long unloadedClassCount, long totalLoadedClassCount, HashMap<String, Long[]> memoryUsage, HashMap<String, Long[]> garbageCollector) {
        this.reset();
        this.vmUpTime = vmUpTime;
        this.availProcessors = availProcessors;
        this.jitCompilationTime = jitCompilationTime;
        this.totalMemory = totalMemory;
        this.freeMemory = freeMemory;
        this.loadedClassCount = loadedClassCount;
        this.unloadedClassCount = unloadedClassCount;
        this.totalLoadedClassCount = totalLoadedClassCount;
        for (Map.Entry<String, Long[]> entry : memoryUsage.entrySet()) {
            this.memoryUsage.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
        }
        for (Map.Entry<String, Long[]> entry : garbageCollector.entrySet()) {
            this.garbageCollector.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
        }
    }

    public float getMemoryUsed() {
        return 100.0f - (float)this.freeMemory / (float)this.totalMemory * 100.0f;
    }

    public void reset() {
        this.freeMemory = -1L;
        this.totalMemory = -1L;
        this.jitCompilationTime = -1L;
        this.vmUpTime = -1L;
        this.totalLoadedClassCount = -1L;
        this.unloadedClassCount = -1L;
        this.loadedClassCount = -1L;
        this.availProcessors = -1;
        this.memoryUsage.clear();
        this.garbageCollector.clear();
    }
}

