/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.metrics.data.transport;

import com.manageengine.apminsight.agent.AgentState;
import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.context.ContextInfo;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.metrics.Metric;
import com.manageengine.apminsight.agent.metrics.store.InstanceMetricConstructor;
import com.manageengine.apminsight.agent.metrics.store.MetricStore;
import com.manageengine.apminsight.agent.metrics.store.MetricStoreController;
import com.manageengine.apminsight.agent.ondemand.OnDemandTasksHandler;
import com.manageengine.apminsight.agent.sequence.SequenceTrace;
import com.manageengine.apminsight.agent.sequence.SequenceTraceStore;
import com.manageengine.apminsight.agent.service.JavaAgentService;
import com.manageengine.apminsight.agent.statistics.StatisticsPrinter;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class MetricDataDispatcher
implements Runnable {
    public static final long DISPATCH_WAIT_TIME = 5000L;
    private long lastDispatched = System.currentTimeMillis();
    private JavaAgent agent;
    private JavaAgentService agentService;
    private static byte cycleCount = 0;

    public MetricDataDispatcher(JavaAgent agent) {
        this.agent = agent;
        this.agentService = agent.getAgentService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            cycleCount = (byte)(cycleCount + 1);
            if (cycleCount % (this.agent.getAgentConfig().getAgentPollingInterval() / 60) != 0) {
                return;
            }
            long startTime = System.currentTimeMillis();
            JavaAgent.logger.log(Level.TRACE, "Metric dispatching started at {} ms", (Object)startTime);
            MetricStore metricStore = MetricStoreController.changeMetricStore();
            SequenceTraceStore seqTraceStore = this.agentService.getSequenceService().getSequenceTraceStore();
            List<SequenceTrace> tracesList = null;
            SequenceTraceStore sequenceTraceStore = seqTraceStore;
            synchronized (sequenceTraceStore) {
                tracesList = seqTraceStore.getSequenceTracesToSend();
            }
            Thread.sleep(5000L);
            InstanceMetricConstructor.construct(metricStore);
            StatisticsPrinter.getGlobalPrinter().print(JavaAgent.logger, Level.INFO, this.agent.getAgentConfig().printAgentStatistics());
            if (cycleCount == 60) {
                cycleCount = 0;
            }
            this.dispatchMetrics(metricStore);
            this.dispatchSequenceTrace(tracesList);
            JavaAgent.logger.log(Level.INFO, "Metric dispatching completed. Time consumed: {} ms", (Object)(System.currentTimeMillis() - startTime));
            this.agent.getAgentConfig().refreshNow();
            JavaAgent.logger.info(OnDemandTasksHandler.getOnDemandTaskStats());
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[MetricDataDispatcher] Exception ", th);
        }
    }

    private void dispatchMetrics(MetricStore metricStore) {
        long startTime = System.currentTimeMillis();
        List<Metric> metricsToDispatch = metricStore.getAllMetrics();
        ArrayList<Metric> metricsToDispatchToAllContexts = new ArrayList<Metric>();
        for (Metric metric : metricsToDispatch) {
            try {
                String contextName = metric.getMetricName().getContextName();
                if (contextName.equals("all")) {
                    metricsToDispatchToAllContexts.add(metric);
                    continue;
                }
                ContextInfo contextInfo = ContextInfoManager.getInstance().getContextInfoIfPresent(contextName);
                if (contextInfo == null) {
                    contextInfo = ContextInfoManager.getInstance().createContextInfoIfNotExists(contextName, null, AgentState.UNMANAGED.toString(), new Properties());
                }
                contextInfo.addContextMetric(metric);
            }
            catch (Throwable th) {
                JavaAgent.logger.warn("Exception while preparing metric dispatch. " + th.getMessage());
            }
        }
        for (ContextInfo contextInfo : ContextInfoManager.getInstance().getAllContexts()) {
            if (!contextInfo.isRegistered()) {
                try {
                    JavaAgent.getInstance().getAgentService().connect(contextInfo);
                }
                catch (Throwable th) {
                    JavaAgent.logger.warn("'" + contextInfo.getContextName() + "' Context registration failed. Exception: " + th.getMessage());
                    contextInfo.getDataToDispatch();
                    continue;
                }
            }
            List<Object> metrics = contextInfo.getDataToDispatch();
            metrics.addAll(metricsToDispatchToAllContexts);
            try {
                long duration;
                if (contextInfo.getInstanceState() == AgentState.MARKED_FOR_DELETE && ((duration = (startTime - contextInfo.agentMarkedForDeleteTime) / 60000L) >= 10L && duration < 30L && duration % 2L != 0L || duration >= 30L && duration < 60L && duration % 5L != 0L || duration >= 60L && duration < 360L && duration % 15L != 0L || duration >= 360L && duration % 60L != 0L)) continue;
                List<Object> data = Arrays.asList(this.lastDispatched, startTime, metrics);
                this.agentService.sendDataToServer(contextInfo, "data", data);
                this.lastDispatched = startTime;
                JavaAgent.logger.info(metrics.size() + " metric(s) dispatched for context '" + contextInfo.getContextName() + "'. Context currently enabled:" + contextInfo.isActive());
            }
            catch (Throwable t) {
                JavaAgent.logger.log(Level.WARN, "Metrics dispatch of size {} failed for context \"{}\". Exception: {} Last successful dispatch time: {}", metrics.size(), contextInfo.getContextName(), t.getMessage(), this.lastDispatched);
            }
        }
        metricStore.cleanMetricStore();
    }

    private void dispatchSequenceTrace(List traceList) {
        for (Object object : traceList) {
            ContextInfo contextInfo = ContextInfoManager.getInstance().getContextInfoIfPresent(((SequenceTrace)object).getContextName());
            if (contextInfo == null) continue;
            contextInfo.addContextMetric(object);
        }
        for (ContextInfo contextInfo : ContextInfoManager.getInstance().getAllContexts()) {
            traceList = contextInfo.getDataToDispatch();
            if (traceList.size() <= 0) continue;
            try {
                long now = System.currentTimeMillis();
                traceList = Arrays.asList(now, now, traceList);
                this.agentService.sendDataToServer(contextInfo, "trace", traceList);
            }
            catch (Exception ex) {
                JavaAgent.logger.log(Level.WARN, "The transaction trace of size {} failed for context \"{}\". Exception: {} Last successful dispatch time: {}", traceList.size(), contextInfo.getContextName(), ex.getMessage(), this.lastDispatched);
            }
        }
    }
}

