/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.ondemand;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.ondemand.OnDemandTasksHandler;

public abstract class OnDemandTask
implements Runnable {
    private String taskName;
    private TaskWeightage weightage;
    private boolean isTaskRunning = false;
    private long scheduledTime;
    private long startTime;

    public OnDemandTask(String taskName, TaskWeightage weightage) {
        this.taskName = taskName;
        this.weightage = weightage;
        this.scheduledTime = System.currentTimeMillis();
    }

    @Override
    public void run() {
        try {
            this.startTime = System.currentTimeMillis();
            JavaAgent.logger.info("Starting {} task scheduled @ {} waited for(ms): {}", this.taskName, this.scheduledTime, this.startTime - this.scheduledTime);
            this.isTaskRunning = true;
            this.runTask();
            this.isTaskRunning = false;
        }
        catch (Throwable th) {
            try {
                JavaAgent.logger.error("{} task aborted due to error {}", this.taskName, th);
                this.isTaskRunning = false;
            }
            catch (Throwable throwable) {
                this.isTaskRunning = false;
                OnDemandTasksHandler.notifyCompleted(this);
                JavaAgent.logger.info("{} task completed. Runtime(ms): {}", this.taskName, System.currentTimeMillis() - this.startTime);
                throw throwable;
            }
            OnDemandTasksHandler.notifyCompleted(this);
            JavaAgent.logger.info("{} task completed. Runtime(ms): {}", this.taskName, System.currentTimeMillis() - this.startTime);
        }
        OnDemandTasksHandler.notifyCompleted(this);
        JavaAgent.logger.info("{} task completed. Runtime(ms): {}", this.taskName, System.currentTimeMillis() - this.startTime);
    }

    public abstract void runTask();

    public abstract boolean abortTask();

    public boolean stop() {
        try {
            this.abortTask();
            this.isTaskRunning = false;
            OnDemandTasksHandler.notifyCompleted(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return !this.isTaskRunning;
    }

    public boolean isTaskRunning() {
        return this.isTaskRunning;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public TaskWeightage getWeightage() {
        return this.weightage;
    }

    public String toString() {
        return this.taskName;
    }

    public static enum TaskWeightage {
        HEAVY,
        LITE;

    }
}

