/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.parser;

import com.manageengine.apminsight.agent.JavaAgent;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StatementParser {
    private static final Pattern JDBC_URL_PATTERN = Pattern.compile(".+:(//|@)(.+:\\d+|.+)(:|/).+");
    private static final Pattern JDBC_URL_PATTERN2 = Pattern.compile(".*[(]host=(.*?)[)].*?[(]port=(\\d+)[)].*");

    public static String getAddress(Object stmt) {
        String address = null;
        String jdbcUrl = null;
        try {
            Method m = stmt.getClass().getMethod("getConnection", new Class[0]);
            m.setAccessible(true);
            Object obj = m.invoke(stmt, new Object[0]);
            if (!stmt.getClass().getName().contains("informix")) {
                m = obj.getClass().getMethod("getMetaData", new Class[0]);
                m.setAccessible(true);
                obj = m.invoke(obj, new Object[0]);
            }
            m = obj.getClass().getMethod("getURL", new Class[0]);
            m.setAccessible(true);
            jdbcUrl = (String)m.invoke(obj, new Object[0]);
            address = StatementParser.getAddress(jdbcUrl.trim());
        }
        catch (Exception ex) {
            JavaAgent.logger.warn("Server address extraction from connection object failed. Exception: " + ex.getMessage());
            JavaAgent.logger.debug("Connection URL: " + jdbcUrl);
        }
        return address;
    }

    private static String getAddress(String jdbcUrl) {
        String address = null;
        Matcher m = JDBC_URL_PATTERN2.matcher(jdbcUrl);
        if (m.matches()) {
            address = m.group(1) + ":" + m.group(2);
        } else {
            m = JDBC_URL_PATTERN.matcher(jdbcUrl);
            if (m.matches()) {
                address = m.group(2).split(",")[0];
            }
        }
        return address;
    }
}

