/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.sequence;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.sequence.SequenceFilterByName;
import com.manageengine.apminsight.agent.util.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SequenceFilterByUrl {
    public static boolean isSkip(String url) {
        if (SequenceFilterByUrlExtension.isSkip(url)) {
            return true;
        }
        return SequenceFilterByName.isSkip(url);
    }

    public static class SequenceFilterByUrlExtension {
        static Set<String> xtensions = Collections.emptySet();

        public static void initialize(String regEx) {
            if (StringUtils.isEmptyString(regEx)) {
                return;
            }
            String[] temp = regEx.replaceAll("\\s*\\*.", "").split(",");
            if (temp.length != 0) {
                xtensions = new HashSet<String>(Arrays.asList(temp));
                JavaAgent.logger.info("SequenceFilterByUrlExtension initialized with values: " + xtensions);
            }
        }

        static void reInitialize(String regEx) {
            SequenceFilterByUrlExtension.initialize(regEx);
        }

        static boolean isSkip(String url) {
            int position = url.lastIndexOf(46);
            if (position == -1) {
                return false;
            }
            try {
                return xtensions.contains(url.substring(position + 1));
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
        }
    }
}

