/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.sequence;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.JavaAgentConstants;
import com.manageengine.apminsight.agent.util.Utils;
import java.io.File;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SequenceNameChanger {
    private static final String CLASSNAME = "[" + SequenceNameChanger.class.getSimpleName() + "] ";
    private static Map<Pattern, String> regExPatterns = new TreeMap<Pattern, String>(new Comparator<Pattern>(){

        @Override
        public int compare(Pattern p1, Pattern p2) {
            return 1;
        }
    });

    public static void initialize(File propertiesFile) {
        Properties propPreserveOrder = new Properties(){
            Map<Object, Object> map = new TreeMap<Object, Object>(new Comparator<Object>(){

                @Override
                public int compare(Object o, Object oo) {
                    return 1;
                }
            });

            @Override
            public Object put(Object key, Object value) {
                return this.map.put(key, value);
            }

            @Override
            public Set<Map.Entry<Object, Object>> entrySet() {
                return this.map.entrySet();
            }
        };
        try {
            Utils.getContentAsProps(propertiesFile, propPreserveOrder);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SequenceNameChanger.initialize(propPreserveOrder.entrySet());
    }

    private static void initialize(Set<Map.Entry<Object, Object>> params) {
        if (params == null) {
            JavaAgent.logger.info(CLASSNAME + "input is null. Dummy namechanger initialized.");
            return;
        }
        regExPatterns.clear();
        for (Map.Entry<Object, Object> e : params) {
            try {
                Pattern pattern = Pattern.compile((String)e.getKey());
                regExPatterns.put(pattern, SequenceNameChanger.normalizeSeqNameByLength((String)e.getValue()));
            }
            catch (PatternSyntaxException ex) {
                JavaAgent.logger.warn(CLASSNAME + "PatternSyntaxException thrown for input: " + e.getKey() + "=" + e.getValue());
            }
        }
        JavaAgent.logger.info(CLASSNAME + "initialized with " + regExPatterns.size() + " records. Pattern: " + regExPatterns);
    }

    public static String executeForSeq(String sequenceName) {
        for (Map.Entry<Pattern, String> e : regExPatterns.entrySet()) {
            Matcher m = e.getKey().matcher(sequenceName);
            if (!m.matches()) continue;
            JavaAgent.logger.debug(CLASSNAME + sequenceName + " named to " + e.getValue());
            return e.getValue();
        }
        return SequenceNameChanger.normalizeSeqNameByLength(sequenceName);
    }

    private static String normalizeSeqNameByLength(String seqName) {
        if (seqName.length() > JavaAgentConstants.SEQUENCENAME_MAX_LENGTH) {
            return seqName.substring(0, JavaAgentConstants.SEQUENCENAME_MAX_LENGTH + 1) + "..";
        }
        return seqName;
    }

    public static void main(String[] args) throws Exception {
        File f = new File("/Volumes/Official/apache-tomcat-7.0.39/apminsight/apminsight.conf");
    }
}

