/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.service;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.api.CustomMetric;
import com.manageengine.apminsight.agent.jmx.CustomJmxExtension;
import com.manageengine.apminsight.agent.jmx.DefaultJmxExtension;
import com.manageengine.apminsight.agent.jmx.GlassfishJmxExtension;
import com.manageengine.apminsight.agent.jmx.JBossASJmxExtension;
import com.manageengine.apminsight.agent.jmx.JettyJmxExtension;
import com.manageengine.apminsight.agent.jmx.JmxExecutioner;
import com.manageengine.apminsight.agent.jmx.JmxExtension;
import com.manageengine.apminsight.agent.jmx.JmxValue;
import com.manageengine.apminsight.agent.jmx.TomcatJmxExtension;
import com.manageengine.apminsight.agent.jmx.WeblogicJmxExtension;
import com.manageengine.apminsight.agent.jmx.WebsphereJmxExtension;
import com.manageengine.apminsight.agent.jmx.WebsphereLibertyJmxExtension;
import com.manageengine.apminsight.agent.jvm.EnvironmentIdentifier;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JmxService {
    private static JmxService jmxService;
    private Set<JmxExtension> extensions = new HashSet<JmxExtension>();
    private JmxExecutioner executor = new JmxExecutioner();
    private int attributesCount = 0;

    private JmxService() {
    }

    public static JmxService getInstance() {
        if (jmxService == null) {
            jmxService = new JmxService();
        }
        return jmxService;
    }

    public void initialize() {
        this.addExtension(new DefaultJmxExtension());
        this.addExtension(CustomJmxExtension.getInstance());
        EnvironmentIdentifier.APP_SERVER appServer = EnvironmentIdentifier.getAppServer();
        if (appServer == EnvironmentIdentifier.APP_SERVER.TOMCAT) {
            this.addExtension(new TomcatJmxExtension());
        } else if (appServer == EnvironmentIdentifier.APP_SERVER.JBOSS) {
            this.addExtension(new JBossASJmxExtension());
        } else if (appServer == EnvironmentIdentifier.APP_SERVER.JETTY) {
            this.addExtension(new JettyJmxExtension());
        } else if (appServer == EnvironmentIdentifier.APP_SERVER.WEBLOGIC) {
            this.addExtension(new WeblogicJmxExtension());
        } else if (appServer == EnvironmentIdentifier.APP_SERVER.GLASSFISH) {
            this.addExtension(new GlassfishJmxExtension());
        } else if (appServer == EnvironmentIdentifier.APP_SERVER.WEBSPHERE) {
            this.addExtension(new WebsphereJmxExtension());
        } else if (appServer == EnvironmentIdentifier.APP_SERVER.WEBSPHERE_LIBERTY) {
            this.addExtension(new WebsphereLibertyJmxExtension());
        }
        JavaAgent.logger.info("[JmxService] JMX Service initialized.");
    }

    public boolean addExtension(JmxExtension extn) {
        return this.extensions.add(extn);
    }

    public JmxExecutioner getJmxExecutioner() {
        return this.executor;
    }

    public void processJmxExtensions() {
        try {
            if (!JavaAgent.getInstance().getAgentConfig().isCaptureJmxMetricsEnabled()) {
                JavaAgent.logger.info("[JmxService] JMX metric capturing has been disabled. No DC");
                return;
            }
            JavaAgent.logger.info("[JmxService] Started processing jmx extenstions. Count: " + this.extensions.size());
            this.attributesCount = 0;
            for (JmxExtension extn : this.extensions) {
                Set<JmxValue> values = this.executor.doExecute(extn);
                this.pushMetricsToStore(extn.getJMXPrefix(), values);
                JavaAgent.logger.debug("[JmxService] Processing completed for JMX Extension: " + extn.toString() + " valid beans: " + values.size());
            }
            JavaAgent.logger.info("[JmxService] Jmx Extensions processing completed.");
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[JmxService] Unexpected error occurred, jmx metrics processing aborted.", th);
        }
    }

    private void pushMetricsToStore(String prefix, Set<JmxValue> jmxValues) {
        for (JmxValue jmxValue : jmxValues) {
            for (Map.Entry<String, Object> attribute : jmxValue.getAttributes().entrySet()) {
                try {
                    Double value = Double.valueOf(attribute.getValue().toString());
                    if (!value.isNaN() && !value.isInfinite()) {
                        CustomMetric.increment(prefix + attribute.getKey(), value);
                        ++this.attributesCount;
                        continue;
                    }
                    JavaAgent.logger.warn("[JmxService] Value received for JMX attribute: '" + attribute.getKey() + "' is not a number");
                }
                catch (NumberFormatException e) {
                    JavaAgent.logger.warn("Unable to convert the jmx attribute to numeric. Actual value: " + attribute.getValue());
                }
                catch (Throwable th) {
                    JavaAgent.logger.warn("Unable to create metric for the attribute: " + attribute.getKey() + " Value: " + attribute.getValue());
                }
            }
        }
    }
}

