/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.service.profiler;

import com.manageengine.apminsight.agent.jvm.monitor.ThreadMxBeanUtil;
import com.manageengine.apminsight.agent.metric.MetricConstants;
import com.manageengine.apminsight.agent.service.profiler.StackElement;
import com.manageengine.apminsight.agent.smart.SmartPackageFilter;
import com.manageengine.apminsight.agent.tracing.StackTrace;
import com.manageengine.org.json.simple.JSONStreamAware;
import com.manageengine.org.json.simple.JSONValue;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ProfilerDatav2
implements JSONStreamAware,
MetricConstants {
    private static final int MAX_DUMP_FILE_SPACE = 5;
    private Map<Integer, String> stackStringIDMapper = new HashMap<Integer, String>();
    private Map<Integer, StackElement> profileTree = new HashMap<Integer, StackElement>();
    private List<File> savedDumps = new ArrayList<File>();
    private final int rootElementID;
    private int totalCallCount = 0;
    private List<ThreadInfo> highCPUThreads;
    private List<ThreadInfo> highMemoryThreads;
    private Set<Integer> markedForInstrumentation = new HashSet<Integer>();
    private long starttime;
    private int profilingStacktraceDepth;

    public ProfilerDatav2(int profilingStackDepth) {
        String rootElement = "java.lang.Thread.run";
        this.rootElementID = rootElement.hashCode();
        this.stackStringIDMapper.put(this.rootElementID, rootElement);
        this.profileTree.put(this.rootElementID, new StackElement(this.rootElementID));
        this.profilingStacktraceDepth = profilingStackDepth;
        this.starttime = System.currentTimeMillis();
    }

    public void addStackTrace(StackTraceElement[] stackTraceElements) {
        List<StackTraceElement> stacktrace = this.trimStripAndFlip(stackTraceElements);
        if (stacktrace == null) {
            return;
        }
        ++this.totalCallCount;
        Integer parentID = this.rootElementID;
        for (StackTraceElement element : stacktrace) {
            StackElement treeElement;
            String stack = this.getStackName(element);
            Integer id = stack.hashCode();
            if (!this.stackStringIDMapper.containsKey(id)) {
                this.stackStringIDMapper.put(id, stack);
            }
            if ((treeElement = this.profileTree.get(id)) == null) {
                treeElement = new StackElement(id);
                this.profileTree.put(id, treeElement);
                if (id != parentID) {
                    this.profileTree.get(parentID).addAsChild(id);
                }
            }
            treeElement.includeLineNumber(element.getLineNumber());
            treeElement.incrementCallCount();
            parentID = id;
        }
    }

    private List<StackTraceElement> trimStripAndFlip(StackTraceElement[] stacktrace) {
        if (stacktrace.length < 1) {
            return null;
        }
        ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>();
        for (StackTraceElement element : stacktrace) {
            if (element.getClassName().matches("com.manageengine.apminsight.agent.*|com.manageengine.org.*")) continue;
            stack.add(element);
            if (stack.size() == this.profilingStacktraceDepth) break;
        }
        Collections.reverse(stack);
        return stack.size() == 0 ? null : stack;
    }

    private String getStackName(StackTraceElement element) {
        if (element == null) {
            return null;
        }
        return element.getClassName() + "." + element.getMethodName();
    }

    public boolean isEmpty() {
        return this.profileTree.isEmpty();
    }

    public long getTotalCallCount() {
        return this.totalCallCount;
    }

    public void setHighCPUThreads(List<ThreadInfo> info) {
        this.highCPUThreads = new ArrayList<ThreadInfo>(info);
    }

    public void setHighMemoryThreads(List<ThreadInfo> info) {
        this.highMemoryThreads = new ArrayList<ThreadInfo>(info);
    }

    public Map getTopNThreadsInfo() {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        for (ThreadInfo info : this.highCPUThreads) {
            boolean isAlsoHighMemory = this.highMemoryThreads.contains(info);
            if (isAlsoHighMemory) {
                this.highMemoryThreads.remove(info);
            }
            data.add(new ThreadDetails(info, true, isAlsoHighMemory).getDataInMap());
        }
        for (ThreadInfo info : this.highMemoryThreads) {
            data.add(new ThreadDetails(info, false, true).getDataInMap());
        }
        HashMap<String, Serializable> topNData = new HashMap<String, Serializable>();
        topNData.put("n_value", Integer.valueOf(this.highCPUThreads.size()));
        topNData.put("data", data);
        return topNData;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        HashMap<String, Map> profilerData = new HashMap<String, Map>();
        profilerData.put("pTree", this.constructTree(this.profileTree.get(this.rootElementID)));
        profilerData.put("top_n", this.getTopNThreadsInfo());
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        list.add(Long.valueOf(this.starttime));
        list.add(Long.valueOf(System.currentTimeMillis()));
        ArrayList<HashMap<String, Map>> data = new ArrayList<HashMap<String, Map>>();
        data.add(profilerData);
        list.add(data);
        JSONValue.writeJSONString(list, out);
    }

    private Map<String, Object> constructTree(StackElement rootElement) {
        if (rootElement != null) {
            HashMap<String, Object> data = new HashMap<String, Object>(4);
            data.put("se", this.stackStringIDMapper.get(rootElement.getStackID()));
            double callPercentage = this.getCallPercentage(rootElement);
            data.put("cpc", callPercentage);
            if (callPercentage > 20.0) {
                this.markedForInstrumentation.add(rootElement.getStackID());
            }
            data.put("line", rootElement.getLineNumbers().toString());
            if (rootElement.getChildren() != null) {
                ArrayList<Map<String, Object>> child = new ArrayList<Map<String, Object>>();
                data.put("child", child);
                for (int id : rootElement.getChildren()) {
                    child.add(this.constructTree(this.profileTree.get(id)));
                }
            } else {
                data.put("child", null);
            }
            return data;
        }
        return null;
    }

    private double getCallPercentage(StackElement rootElement) {
        if (rootElement.getStackID() == this.rootElementID) {
            return 100.0;
        }
        int noOfLineCount = rootElement.getLineNumbers().size();
        noOfLineCount = noOfLineCount == 0 ? 1 : noOfLineCount;
        int callCount = rootElement.getCallCount() / noOfLineCount * 100;
        double cpc = (float)callCount / ((float)this.getTotalCallCount() * 1.0f);
        return cpc > 100.0 ? 100.0 : cpc;
    }

    public Map<String, String> getMarkedClassesForInstrumentation() {
        HashMap<String, String> data = new HashMap<String, String>();
        for (Integer stackID : this.markedForInstrumentation) {
            String stack = this.stackStringIDMapper.get(stackID);
            int clzMethodSeparatorIndex = stack.lastIndexOf(46);
            String clz = stack.substring(0, clzMethodSeparatorIndex).replace('.', '/');
            if (SmartPackageFilter.getInstance().isExcludedPackage(clz)) continue;
            String method = stack.substring(clzMethodSeparatorIndex + 1);
            if (data.containsKey(clz)) {
                method = (String)data.get(clz) + ", " + method;
            }
            data.put(clz, method);
        }
        return data;
    }

    public boolean saveDump(File dump) {
        return this.savedDumps.add(dump);
    }

    public List<File> getSavedDumps() {
        return this.savedDumps;
    }

    public boolean isDumpSpaceAvailable() {
        return this.savedDumps.size() < 5;
    }

    private class ThreadDetails
    implements JSONStreamAware,
    MetricConstants {
        private boolean isHighCPU = false;
        private boolean isHighMemory = false;
        private ThreadInfo threadInfo;

        public ThreadDetails(ThreadInfo info, boolean highCPU, boolean highMemory) {
            this.isHighCPU = highCPU;
            this.isHighMemory = highMemory;
            this.threadInfo = info;
        }

        public long getThreadId() {
            return this.threadInfo.getThreadId();
        }

        public String getThreadName() {
            return this.threadInfo.getThreadName();
        }

        public String getThreadState() {
            return this.threadInfo.getThreadState().name();
        }

        public StackTraceElement[] getStackTrace() {
            return this.threadInfo.getStackTrace();
        }

        public long getCPUTime() {
            try {
                return TimeUnit.NANOSECONDS.toMillis(ThreadMxBeanUtil.getThreadTotalCpuTimeInNanoSec(this.getThreadId()));
            }
            catch (Throwable th) {
                return -1L;
            }
        }

        public long getMemoryAllocated() {
            try {
                return ThreadMxBeanUtil.getThreadAllocatedBytes(this.getThreadId());
            }
            catch (Throwable th) {
                return -1L;
            }
        }

        @Override
        public void writeJSONString(Writer out) throws IOException {
            JSONValue.writeJSONString(this.getDataInMap(), out);
        }

        public Map<String, Object> getDataInMap() {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("threadID", this.getThreadId());
            data.put("name", this.getThreadName());
            data.put("state", this.getThreadState());
            data.put("cputime", this.getCPUTime());
            data.put("memalloc", this.getMemoryAllocated());
            data.put("isHighCPU", this.isHighCPU);
            data.put("isHighMemory", this.isHighMemory);
            data.put("stacktrace", new StackTrace(this.getStackTrace(), false));
            return data;
        }
    }
}

