/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.service.profiler;

import java.util.HashSet;
import java.util.Set;

public class StackElement {
    private Integer stackID;
    private Set<Integer> children;
    private Set<Integer> lineNumbers = new HashSet<Integer>();
    private int callCount;

    public StackElement(Integer stackID) {
        this.stackID = stackID;
    }

    public void includeLineNumber(int lineNo) {
        lineNo = lineNo < 1 ? 0 : lineNo;
        this.lineNumbers.add(lineNo);
    }

    public int incrementCallCount() {
        return ++this.callCount;
    }

    public void addAsChild(Integer id) {
        if (this.children == null) {
            this.children = new HashSet<Integer>();
        }
        this.children.add(id);
    }

    public Integer getStackID() {
        return this.stackID;
    }

    public int getCallCount() {
        return this.callCount;
    }

    public Set<Integer> getChildren() {
        return this.children;
    }

    public Set<Integer> getLineNumbers() {
        return this.lineNumbers;
    }

    public String toString() {
        return this.getStackID() + "\t" + this.getCallCount() + "\t" + this.getChildren();
    }
}

