/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.statistics;

import com.manageengine.apminsight.agent.jvm.monitor.ThreadMxBeanUtil;
import com.manageengine.apminsight.agent.metrics.store.MetricStore;
import com.manageengine.apminsight.agent.metrics.store.MetricStoreController;
import com.manageengine.apminsight.agent.sequence.SequenceTraceStore;
import com.manageengine.apminsight.agent.thread.WorkerThreadFactory;
import com.manageengine.apminsight.agent.trackers.db.QueryHolder;

public class StatisticsData {
    public static String getStatisticsData() {
        StringBuilder sb = new StringBuilder("\n--- Statistics ---");
        StatisticsData.uploadMetricStoreStatistics(sb);
        StatisticsData.uploadTraceStoreStatistics(sb);
        StatisticsData.uploadTrackerStoreStatistics(sb);
        StatisticsData.uploadPreparedQueryStoreStatistics(sb);
        StatisticsData.uploadAgentPerformanceStats(sb);
        sb.append('\n');
        return sb.toString();
    }

    static void uploadMetricStoreStatistics(StringBuilder sb) {
        for (MetricStore m : MetricStoreController.getAllMetricStore()) {
            int[] weight = m.getOccupiedSize();
            sb.append("\n" + m.getName() + "- Apdex Weight: " + weight[0] + " Metrics Weight: " + weight[1]);
        }
    }

    static void uploadTraceStoreStatistics(StringBuilder sb) {
        sb.append("\nTraceStore Weight: " + SequenceTraceStore.getOccupiedSize());
    }

    static void uploadTrackerStoreStatistics(StringBuilder sb) {
    }

    static void uploadPreparedQueryStoreStatistics(StringBuilder sb) {
        sb.append("\nPreparedQueryStore Weight: " + QueryHolder.getOccupiedSize());
    }

    static void uploadAgentPerformanceStats(StringBuilder sb) {
        Long[] agentThreads = WorkerThreadFactory.getInstance().getAgentThreadIds();
        long cputime = 0L;
        long memalloc = 0L;
        for (Long agentThreadId : agentThreads) {
            cputime += ThreadMxBeanUtil.getThreadTotalCpuTimeInNanoSec(agentThreadId);
            memalloc += ThreadMxBeanUtil.getThreadAllocatedBytes(agentThreadId);
        }
        sb.append("\nCPU Time: " + (cputime /= 1000000L) + "ms\nMemory Allocated: " + (memalloc /= 0x100000L) + "MB");
    }
}

