/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.tracing;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.JavaAgentConstants;
import com.manageengine.apminsight.agent.logging.AgentLogger;
import com.manageengine.apminsight.agent.trackers.CallerAsyncRootTracker;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class AsyncTracerService
implements JavaAgentConstants {
    private static AsyncTracerService asyncTracerService;
    private Map<Integer, CallerAsyncRootTracker> asyncWaitingTasks;
    private AgentLogger logger;
    private long ttl = ASYNC_TRACKERS_TTL_DV;

    private AsyncTracerService() {
        this.asyncWaitingTasks = Collections.synchronizedMap(new HashMap());
        this.logger = JavaAgent.logger;
    }

    public void init(Map<String, Object> props) {
        Object temp = props.get("async.tracker.ttl");
        if (temp != null) {
            this.ttl = Long.parseLong(temp.toString().trim());
        }
        this.logger.info("Async Tracer Service updated");
    }

    public static AsyncTracerService getInstance() {
        if (asyncTracerService == null) {
            asyncTracerService = new AsyncTracerService();
        }
        return asyncTracerService;
    }

    public void addToWaitList(Integer id, CallerAsyncRootTracker tracker) {
        this.asyncWaitingTasks.put(id, tracker);
    }

    public CallerAsyncRootTracker evictTracker(Integer id) {
        return this.asyncWaitingTasks.remove(id);
    }

    public CallerAsyncRootTracker getTracker(Integer id) {
        return this.asyncWaitingTasks.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateDeadTrackers() {
        HashMap<Integer, CallerAsyncRootTracker> currentWL;
        if (this.asyncWaitingTasks.isEmpty()) {
            return;
        }
        this.logger.info("[AsyncTracerService] Invalidate process initiated");
        Map<Integer, CallerAsyncRootTracker> map = this.asyncWaitingTasks;
        synchronized (map) {
            currentWL = new HashMap<Integer, CallerAsyncRootTracker>(this.asyncWaitingTasks);
        }
        if (currentWL == null || currentWL.isEmpty()) {
            return;
        }
        HashSet deadTrackers = new HashSet();
        for (Map.Entry entry : currentWL.entrySet()) {
            CallerAsyncRootTracker tracker = (CallerAsyncRootTracker)entry.getValue();
            if (System.currentTimeMillis() - tracker.getStartTime() < this.ttl) continue;
            deadTrackers.add(entry.getKey());
            tracker.markTimedOut();
        }
        if (deadTrackers.isEmpty()) {
            return;
        }
        Map<Integer, CallerAsyncRootTracker> map2 = this.asyncWaitingTasks;
        synchronized (map2) {
            this.asyncWaitingTasks.keySet().removeAll(deadTrackers);
        }
        this.logger.info("[AsyncTracerService] {} txns/trackers invalidated.", deadTrackers.size());
        currentWL.clear();
        deadTrackers.clear();
    }
}

