/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.tracing.exception;

import com.manageengine.apminsight.agent.tracing.exception.ErrorThrowable;

public abstract class ErrorRecord {
    private static final int USER_MESSAGE_MAXLENGTH = 256;
    private long timestamp;
    private String userMessage;
    private ErrorThrowable throwable;

    public ErrorRecord(long logTime, String message, ErrorThrowable throwable) {
        this.timestamp = logTime;
        if (throwable == null) {
            return;
        }
        this.throwable = throwable;
        if (message != null) {
            this.userMessage = message.trim();
            if (this.userMessage.length() > 256) {
                this.userMessage = this.userMessage.substring(0, 256 - "..".length()) + "..";
            }
        }
    }

    public long getLogTime() {
        return this.timestamp;
    }

    public String getUserMessage() {
        return this.userMessage;
    }

    public ErrorThrowable getThrowable() {
        return this.throwable;
    }

    public abstract String getErrorType();

    public int hashCode() {
        return this.throwable.hashCode();
    }

    public boolean equals(Object obj) {
        return this.throwable.equals(((ErrorRecord)obj).throwable);
    }
}

