/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers;

import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.jvm.monitor.ThreadMxBeanUtil;
import com.manageengine.apminsight.agent.trackers.CallerAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.background.BackgroundSeqRootTracker;
import java.util.concurrent.TimeUnit;

public class CalleeAsyncRootTracker
extends BackgroundSeqRootTracker {
    private CallerAsyncRootTracker parentTracker;
    private long threadId;
    private long cputime;
    private long memoryalloc;
    private String threadName;

    public CalleeAsyncRootTracker(PointcutProperties pointcutProperties, CallerAsyncRootTracker callerTracker) {
        super(pointcutProperties, null, null);
        this.parentTracker = callerTracker;
        this.captureThreadInfo();
    }

    private void captureThreadInfo() {
        Thread thread = Thread.currentThread();
        this.threadId = thread.getId();
        this.threadName = thread.getName();
        this.cputime = ThreadMxBeanUtil.getCurrThreadTotalCpuTimeInNanoSec();
        this.memoryalloc = ThreadMxBeanUtil.getCurrThreadAllocatedBytes();
    }

    @Override
    public void quit(int opcode, Object returnValue) {
        super.quit(opcode, returnValue);
        this.parentTracker.markCompleted(returnValue);
    }

    @Override
    public void quit(Throwable th) {
        super.quit(th);
        this.parentTracker.markFailed(th);
    }

    @Override
    protected void quit() {
        super.quit();
        this.cputime = Math.max(this.cputime, ThreadMxBeanUtil.getCurrThreadTotalCpuTimeInNanoSec() - this.cputime);
        this.memoryalloc = Math.max(this.memoryalloc, ThreadMxBeanUtil.getCurrThreadAllocatedBytes() - this.memoryalloc);
    }

    public String getThreadInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("ThreadName: ");
        sb.append(this.threadName);
        sb.append(", ID: ");
        sb.append(this.threadId);
        sb.append(", CPU Time: ");
        sb.append(TimeUnit.NANOSECONDS.toMillis(this.cputime));
        sb.append("ms, Memory Alloted: ");
        sb.append(this.memoryalloc / 1024L);
        sb.append("kb");
        return sb.toString();
    }
}

