/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ApdexMetric;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.HTTPMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.WebSeqRootTracker;
import com.manageengine.apminsight.agent.trackers.http.ServerHttpResponse;
import com.manageengine.apminsight.agent.trackers.http.ServletHttpResponse;
import com.manageengine.apminsight.agent.trackers.micronaut.MicronautHttpResponse;
import com.manageengine.apminsight.agent.trackers.micronaut.MicronautNettyTracker;
import java.util.Map;

public class WebSeqResponseCodeTracker
extends WebSeqRootTracker {
    private Object httpResponseObj;
    private int httpRespCode = 0;
    private long httpBytesWritten = -1L;
    private long httpRequestSize = -1L;

    public WebSeqResponseCodeTracker(PointcutProperties pointcutProperties, Object thiz, Object[] args) {
        super(pointcutProperties, thiz, args);
        try {
            if (this.httpReq != null) {
                this.httpRequestSize = this.httpReq.getContentLength();
            }
        }
        catch (Exception e) {
            JavaAgent.logger.warn("Error occurred while fetching request size. Exception: " + e.getMessage());
        }
        if (!(this instanceof MicronautNettyTracker)) {
            this.httpResponseObj = args[1];
        }
    }

    @Override
    protected void quit() {
        super.quit();
        if (this instanceof MicronautNettyTracker && !((MicronautNettyTracker)this).isTrackingComplete()) {
            return;
        }
        try {
            ServerHttpResponse response = this instanceof MicronautNettyTracker ? new MicronautHttpResponse(this.httpResponseObj) : new ServletHttpResponse(this.httpResponseObj);
            this.httpRespCode = response.getResponseStatus();
            if (this.httpRespCode == 404) {
                this.seqName = "404-Requests";
            }
            this.httpBytesWritten = response.getBytesWritten();
        }
        catch (Exception e) {
            JavaAgent.logger.warn("Encountered error while handling response status. Exception: " + e.getMessage());
        }
        this.httpResponseObj = null;
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childTrackersDuration, MetricData metricData) {
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.duration - childTrackersDuration, this.isErroneous());
        if (this.httpRespCode >= 400) {
            ((HTTPMetric)metricData).recordHttpRespCode(this.httpRespCode);
            ((ApdexMetric)metricData).recordErroneousData(this.getDuration());
        } else {
            ((ApdexMetric)metricData).recordData(this.getDuration(), seqHeader.getApplicationConfig().getWebSeqConfig().getApdexThreshold());
        }
        if (seqHeader.getApplicationConfig().getWebSeqConfig().isCaptureHttpBytesEnabled()) {
            ((HTTPMetric)metricData).recordBytesInOut(this.httpRequestSize, this.httpBytesWritten);
        }
        return true;
    }

    public int getResponseCode() {
        return this.httpRespCode;
    }

    @Override
    public boolean isErroneous() {
        if (this.child == null) {
            return false;
        }
        return this.child.isErroneous();
    }

    @Override
    public Throwable getErrorCause() {
        if (this.child == null) {
            return null;
        }
        return this.child.getErrorCause();
    }

    @Override
    public Map<String, Object> getContextualMetrics() {
        Map<String, Object> contextualMetrics = super.getContextualMetrics();
        if (this.httpRespCode != 0) {
            contextualMetrics.put("httpcode", this.httpRespCode);
        }
        if (this.httpBytesWritten != -1L) {
            contextualMetrics.put("hbytes", this.httpBytesWritten);
        }
        if (this.httpRequestSize != -1L) {
            contextualMetrics.put("hbytesin", this.httpRequestSize);
        }
        return contextualMetrics;
    }

    @Override
    public String getTrackerSignature() {
        return this.pointcutProperties.getSignature();
    }

    public void setHttpResponseObj(Object httpResponseObj) {
        this.httpResponseObj = httpResponseObj;
    }
}

