/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.api.CustomTracker;
import com.manageengine.apminsight.agent.config.WebSequenceConfig;
import com.manageengine.apminsight.agent.context.ContextInfo;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ApdexMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.AbstractRootTracker;
import com.manageengine.apminsight.agent.trackers.http.HttpParamsObfuscator;
import com.manageengine.apminsight.agent.trackers.http.ServerHttpRequest;
import com.manageengine.apminsight.agent.trackers.http.ServerHttpResponse;
import com.manageengine.apminsight.agent.trackers.http.ServletHttpRequest;
import com.manageengine.apminsight.agent.trackers.http.ServletHttpResponse;
import com.manageengine.apminsight.agent.trackers.micronaut.MicronautHttpRequest;
import com.manageengine.apminsight.agent.trackers.micronaut.MicronautNettyTracker;
import com.manageengine.apminsight.agent.util.SequenceURINormalizer;
import com.manageengine.org.apache.logging.log4j.Level;
import com.manageengine.org.json.simple.JSONObject;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class WebSeqRootTracker
extends AbstractRootTracker {
    private static final String SEQ_NAMESPACE_PREFIX = "transaction/http/";
    protected ServerHttpRequest httpReq;
    protected String httpMethod = null;
    protected String httpContext = null;
    protected HttpParams httpParams = null;
    protected Map<String, List<String>> httpHeaders;
    protected String rumTraceId;
    protected String syntheticKey;

    public WebSeqRootTracker(PointcutProperties pointcutProperties, Object thiz, Object[] args) {
        super(pointcutProperties, thiz, args);
        try {
            if (SequenceSpace.SEQUENCE_BOOK.get().currentTrackersCount() == 0 && args != null && args.length > 0) {
                this.httpReq = this instanceof MicronautNettyTracker ? new MicronautHttpRequest(args[1]) : new ServletHttpRequest(args[0]);
                this.httpContext = this.getContextPath();
                this.recordHttpHeaders();
                if (!(this instanceof MicronautNettyTracker)) {
                    this.setDTResponseHeader(new ServletHttpResponse(args[1]));
                }
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Couldn't able to create HttpReq object." + th.getMessage());
        }
    }

    public void setDTResponseHeader(ServerHttpResponse response) {
        try {
            String id;
            ContextInfo context = ContextInfoManager.getInstance().getContextInfoIfPresent(this.httpContext);
            if (context != null && context.isActive() && context.getConfig().isDistributedTracingEnabled() && (id = this.httpReq.getHeader("X-Site24x7-Id")) != null && JavaAgent.getInstance().agentConfig.getDistributedTracingId().equals(id)) {
                HashMap<String, Object> dtData = new HashMap<String, Object>();
                dtData.put("s_time", this.startTime);
                dtData.put("t_name", this.getSequenceNameSpace());
                dtData.put("instance_id", context.getInstanceID());
                response.addHeader("X-Site24x7-DT-Data", JSONObject.toJSONString(dtData));
                JavaAgent.logger.debug("[DistributedTracing] Adding response header, url " + this.getSequenceName() + " DT-DATA:" + dtData + " isSuccessfull: " + response.containsHeader("X-Site24x7-DT-Data"));
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "Unable to validate distributed tracing id. Exception: ", th);
        }
    }

    @Override
    protected void quit() {
        super.quit();
        if (this.httpReq != null && !this.pointcutProperties.getInterceptedClassName().contains("/jersey/") && SequenceSpace.SEQUENCE_BOOK.get().getConfig().getWebSeqConfig().isRecordSequenceTraceInputParams()) {
            this.httpParams = new HttpParams(this.httpReq);
        }
        this.httpReq = null;
    }

    @Override
    public String getSequenceNameSpace() {
        return SEQ_NAMESPACE_PREFIX + this.getSequenceName();
    }

    @Override
    protected String assignSequenceName() {
        if (this.httpReq == null) {
            this.seqName = "unknown";
            return this.seqName;
        }
        this.httpContext = this.getContextPath();
        WebSequenceConfig webSeqConfig = ContextInfoManager.getInstance().getContextInfoOrDefault(this.httpContext).getConfig().getWebSeqConfig();
        try {
            URL url = new URL(this.httpReq.getRequestURL());
            this.unnormalizedSeqName = url.getPath();
            this.seqName = SequenceURINormalizer.normalizeURI(this.unnormalizedSeqName);
            if (webSeqConfig.canSeqNamingUseRequestURL()) {
                String hostPart = url.getHost() + (url.getPort() != -1 ? ":" + url.getPort() : "") + "/";
                this.unnormalizedSeqName = hostPart + this.unnormalizedSeqName;
                this.seqName = hostPart + this.seqName;
            }
        }
        catch (Exception e) {
            JavaAgent.logger.warn("could not able to get requestURL. Exception: " + e.getMessage());
            this.seqName = "unknown";
        }
        try {
            this.httpMethod = this.httpReq.getMethod();
            if (webSeqConfig.seqNamingUseMethodName()) {
                this.unnormalizedSeqName = this.httpMethod + " - " + this.unnormalizedSeqName;
                this.seqName = this.httpMethod + " - " + this.seqName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hasMetric = true;
        return this.seqName;
    }

    public String getContextPath() {
        try {
            this.httpContext = this.httpContext != null ? this.httpContext : (this.httpReq != null && JavaAgent.getInstance().agentConfig.isContextMonitoringEnabled() ? this.httpReq.getContextPath() : "");
        }
        catch (Exception e) {
            JavaAgent.logger.warn("Error getting context path for transaction. Exception: " + e.getMessage());
            this.httpContext = "";
        }
        return this.httpContext;
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        if (this.hasMetric) {
            if (this.isErroneous()) {
                ((ApdexMetric)metricData).recordErroneousData(this.getDuration());
            } else {
                ((ApdexMetric)metricData).recordData(this.getDuration(), seqHeader.getApplicationConfig().getWebSeqConfig().getApdexThreshold());
            }
        }
        return this.hasMetric;
    }

    private void recordHttpHeaders() {
        this.recordRUMSpecificHeaders();
        this.recordSyntheticMonitoringHeader();
        WebSequenceConfig config = ContextInfoManager.getInstance().getContextInfoOrDefault(this.httpContext).getConfig().getWebSeqConfig();
        if (!config.isCaptureHttpHeadersEnabled()) {
            return;
        }
        try {
            String excludePattern = "(?i)" + config.getExcludeHttpHeadersRegex();
            List<String> headersPresent = this.httpReq.getHeaderNames();
            for (String header : headersPresent) {
                if (header.matches(excludePattern)) continue;
                if (this.httpHeaders == null) {
                    this.httpHeaders = new HashMap<String, List<String>>();
                }
                this.httpHeaders.put(header, Collections.singletonList(this.httpReq.getHeader(header)));
            }
        }
        catch (Exception e) {
            JavaAgent.logger.log(Level.WARN, "Couldn't extract HTTP request headers. ", (Object)e.getMessage());
        }
    }

    private void recordSyntheticMonitoringHeader() {
        try {
            this.syntheticKey = this.httpReq.getHeader("Site24x7SyntheticKey");
            if (this.syntheticKey != null) {
                SequenceSpace.SEQUENCE_BOOK.get().setBypassSampling(true);
                CustomTracker.addParameter("Site24x7SyntheticKey", this.syntheticKey);
                JavaAgent.logger.trace("Received Synthetic key '{}' for txn '{}'", this.syntheticKey, this.getSequenceName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recordRUMSpecificHeaders() {
        try {
            String appKey = this.httpReq.getHeader("X-SITE24X7-RUM-APPKEY");
            ContextInfo contextInfo = ContextInfoManager.getInstance().getContextInfoIfPresent(this.httpContext);
            if (appKey != null && contextInfo != null && contextInfo.isActive()) {
                contextInfo.addRumAppKey(appKey);
                JavaAgent.logger.trace("Received RUM appKey '{}' for txn '{}' for context '{}'", appKey, this.getSequenceName(), contextInfo.getContextName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.rumTraceId = this.httpReq.getHeader("X-SITE24X7-RUM-TRACEID");
            if (this.rumTraceId != null) {
                JavaAgent.logger.trace("Received RUM traceId '{}' for txn '{}'", this.rumTraceId, this.getSequenceName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Map<String, Object> getContextualMetrics() {
        LinkedHashMap<String, Object> xtraMetrics = new LinkedHashMap<String, Object>(4, 1.0f);
        xtraMetrics.put("http_method_name", this.httpMethod);
        if (this.httpParams != null) {
            xtraMetrics.put("http_query_str", this.httpParams.queryString);
            xtraMetrics.put("http_input_params", this.httpParams.paramMap);
        }
        if (this.httpHeaders != null) {
            xtraMetrics.put("http_headers", this.httpHeaders);
        }
        if (this.rumTraceId != null) {
            xtraMetrics.put("trace_id", this.rumTraceId);
        }
        if (this.syntheticKey != null) {
            xtraMetrics.put("Site24x7SyntheticKey", this.syntheticKey);
        }
        return xtraMetrics;
    }

    public String getSyntheticKey() {
        return this.syntheticKey;
    }

    protected static class HttpParams {
        private String queryString;
        private Map<String, List<String>> paramMap;

        public HttpParams(ServerHttpRequest httpReq) {
            this.captureHttpParams(httpReq);
        }

        private void captureHttpParams(ServerHttpRequest httpReq) {
            try {
                httpReq.setCharacterEncoding(JavaAgent.getInstance().getAgentConfig().getCharsetEncoding());
            }
            catch (Exception ex) {
                JavaAgent.logger.log(Level.WARN, "Unable to set '{}' as CharacterEncoding for sequence {}. Exception: " + ex.getCause());
            }
            try {
                this.queryString = HttpParamsObfuscator.obfuscate(httpReq.getQueryString());
                Map paramMap = httpReq.getParameterMap();
                if (paramMap != null && !paramMap.isEmpty()) {
                    this.paramMap = new LinkedHashMap<String, List<String>>(paramMap.size());
                    for (Map.Entry entry : paramMap.entrySet()) {
                        this.paramMap.put((String)entry.getKey(), Arrays.asList(HttpParamsObfuscator.obfuscate((String)entry.getKey(), (String[])entry.getValue())));
                    }
                }
            }
            catch (Exception e) {
                JavaAgent.logger.warn("Unable to get HttpParam metrics." + e.getLocalizedMessage());
            }
        }
    }
}

