/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.api;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.background.BackgroundSeqRootTracker;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApiAnnotationTracker
extends BackgroundSeqRootTracker {
    private static final Pattern TRANSACTION_NAME_PATTERN = Pattern.compile(".*txnName=((.+?);.+|(.+))");
    private String transactionName = null;

    public ApiAnnotationTracker(PointcutProperties pointcut, Object thiz, Object[] args, String annotationAttributes) {
        super(pointcut, thiz, args);
        try {
            Matcher matcher = TRANSACTION_NAME_PATTERN.matcher(annotationAttributes);
            if (matcher.matches()) {
                this.transactionName = matcher.group(2) != null ? matcher.group(2) : matcher.group(3);
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "Unable to extract annotation values, using default values on method:{}. Exception: {}", pointcut.toString(), th);
        }
    }

    @Override
    protected String assignSequenceName() {
        if (this.transactionName == null) {
            return super.assignSequenceName();
        }
        this.seqName = this.transactionName;
        this.hasMetric = true;
        return this.seqName;
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        super.generateMetric(seqHeader, childDuration, metricData);
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.duration - childDuration, this.isErroneous());
        return this.hasMetric;
    }
}

