/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.cassandra;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.trackers.db.AbstractDBTracker;
import java.util.Iterator;

public class CassandraDatastax4xTracker
extends AbstractDBTracker {
    private Object statement;

    public CassandraDatastax4xTracker(PointcutProperties pointcutProperties, Object thisObj, Object[] args) {
        super(pointcutProperties, thisObj, args);
        this.statement = args != null && args.length > 0 ? args[0] : null;
    }

    @Override
    public void quit(int opcode, Object returnValue) {
        super.quit(opcode, returnValue);
        if (JavaAgentConfig.captureHostDetails) {
            this.collectQueriedServerAddress(returnValue);
        }
    }

    @Override
    public void quit(Throwable th) {
        super.quit(th);
        if (JavaAgentConfig.captureHostDetails) {
            this.collectQueriedServerAddress(th);
        }
    }

    @Override
    protected void quit() {
        super.quit();
        this.queries = this.extractQuery();
        this.statement = null;
    }

    private String[] extractQuery() {
        if (this.statement == null) {
            return null;
        }
        try {
            String className = this.statement.getClass().getSimpleName();
            if (className.contains("SimpleStatement")) {
                return new String[]{this.extractQueryFromSimpleStatement(this.statement)};
            }
            if (className.contains("BoundStatement")) {
                return new String[]{this.extractQueryFromBoundStatement(this.statement)};
            }
            if (className.contains("BatchStatement")) {
                int size = (Integer)this.statement.getClass().getMethod("size", new Class[0]).invoke(this.statement, new Object[0]);
                Iterator statementItr = (Iterator)this.statement.getClass().getMethod("iterator", new Class[0]).invoke(this.statement, new Object[0]);
                String[] statements = new String[size];
                int i = 0;
                while (statementItr.hasNext()) {
                    Object stmt = statementItr.next();
                    String stmtClassName = stmt.getClass().getSimpleName();
                    if (stmtClassName.contains("SimpleStatement")) {
                        statements[i++] = this.extractQueryFromSimpleStatement(stmt);
                        continue;
                    }
                    if (!stmtClassName.contains("BoundStatement")) continue;
                    statements[i++] = this.extractQueryFromBoundStatement(stmt);
                }
                return statements;
            }
        }
        catch (Throwable t) {
            JavaAgent.logger.warn("[CassandraDatastax4xTracker] Error occurred extracting query: " + t.getMessage());
        }
        return null;
    }

    private String extractQueryFromSimpleStatement(Object statement) throws Exception {
        return (String)statement.getClass().getMethod("getQuery", new Class[0]).invoke(statement, new Object[0]);
    }

    private String extractQueryFromBoundStatement(Object statement) throws Exception {
        Object prepStmt = statement.getClass().getMethod("getPreparedStatement", new Class[0]).invoke(statement, new Object[0]);
        return (String)prepStmt.getClass().getMethod("getQuery", new Class[0]).invoke(prepStmt, new Object[0]);
    }

    private void collectQueriedServerAddress(Object obj) {
        try {
            Object executionInfo = obj.getClass().getMethod("getExecutionInfo", new Class[0]).invoke(obj, new Object[0]);
            Object coordinator = executionInfo.getClass().getMethod("getCoordinator", new Class[0]).invoke(executionInfo, new Object[0]);
            Object endPoint = coordinator.getClass().getMethod("getEndPoint", new Class[0]).invoke(coordinator, new Object[0]);
            this.serverAddress = endPoint.getClass().getMethod("resolve", new Class[0]).invoke(endPoint, new Object[0]).toString();
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[CassandraDatastax4xTracker] Error occurred while retrieving queried host: " + th.getMessage());
        }
    }
}

