/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.db;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metric.MetricConstants;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.metrics.MetricName;
import com.manageengine.apminsight.agent.metrics.MetricType;
import com.manageengine.apminsight.agent.metrics.ResponseTimeMetric;
import com.manageengine.apminsight.agent.metrics.store.MetricStore;
import com.manageengine.apminsight.agent.metrics.store.MetricStoreController;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.tracing.StackTrace;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.trackers.db.DatabaseTracker;
import com.manageengine.apminsight.agent.trackers.db.QueryInfo;
import com.manageengine.apminsight.agent.trackers.db.QueryLiteralRemover;
import com.manageengine.apminsight.agent.trackers.db.QueryParser;
import com.manageengine.apminsight.agent.util.InetAddressUtil;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.org.apache.logging.log4j.Level;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractDBTracker
extends DefaultTracker
implements DatabaseTracker,
MetricConstants {
    protected String[] queries;
    protected String serverAddress;
    protected StackTraceElement[] stackTraceElements = null;
    protected static final String DUMMY_DB = "dummy-db";
    protected boolean shouldRemoveQueryLiterals;

    public AbstractDBTracker(PointcutProperties pointcutProps, Object thiz, Object[] args) {
        super(pointcutProps, thiz, args);
        this.isLeafTracker = true;
    }

    @Override
    protected void quit() {
        super.quit();
        try {
            SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
            if ((float)this.duration > seqSpace.getConfig().getSqlTraceThreshold()) {
                this.stackTraceElements = Thread.currentThread().getStackTrace();
                seqSpace.setRecentDelayedSql(this);
            }
            this.shouldRemoveQueryLiterals = seqSpace.getConfig().shouldRemoveQueryLiterals();
        }
        catch (Throwable e) {
            JavaAgent.logger.warn("Unable to dump thread stack trace. Exception: " + e.getMessage() + " Try adding permission to dump thread stack trace in your security policy");
        }
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childTrackersDuration, MetricData metricData) {
        this.serverAddress = InetAddressUtil.standardizeServerAddress(this.serverAddress);
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.serverAddress, this.duration - childTrackersDuration, this.isErroneous());
        if (this.isMetricHolded()) {
            String contextName = seqHeader.getContextName();
            String seqNameSpace = seqHeader.getRootTracker().getSequenceNameSpace();
            MetricStore metricStore = MetricStoreController.getMetricStore();
            String metricName = "db/all/all/dummy-db";
            ResponseTimeMetric metric = (ResponseTimeMetric)metricStore.getMetric(new MetricName(contextName, "", metricName){

                @Override
                public String getNameSpace() {
                    return this.getContextName();
                }
            }, MetricType.RESPONSETIME, false).getMetricData();
            metric.setContextName(contextName);
            if (this.isErroneous()) {
                metric.recordErroneousData(this.duration);
            } else {
                metric.recordData(this.duration);
            }
            this.duration /= this.queries.length;
            for (int i = 0; i < this.queries.length; ++i) {
                this.queries[i] = QueryParser.standardizeQuery(this.queries[i]);
                String query = this.queries[i];
                if (query == null) continue;
                try {
                    if (this.shouldRemoveQueryLiterals) {
                        query = this.queries[i] = QueryLiteralRemover.removeLiterals(query);
                    }
                    QueryInfo queryInfo = QueryParser.getQueryInfo(query);
                    String metricName1 = "";
                    if (queryInfo != null) {
                        metricName = "db/" + queryInfo.getOperation().toLowerCase(Locale.ENGLISH) + "/" + "all" + "/" + DUMMY_DB;
                        metricName1 = "db/" + queryInfo.getOperation().toUpperCase(Locale.ENGLISH) + "/" + queryInfo.getTable() + "/" + DUMMY_DB;
                    } else {
                        if (!this.useOrginalQuery(query)) continue;
                        metricName = "db/select/all/dummy-db";
                        metricName1 = "db/" + query + "/" + " " + "/" + DUMMY_DB;
                    }
                    metric = (ResponseTimeMetric)metricStore.getMetric(new MetricName(contextName, "", metricName){

                        @Override
                        public String getNameSpace() {
                            return this.getContextName();
                        }
                    }, MetricType.RESPONSETIME, false).getMetricData();
                    metric.setContextName(contextName);
                    ResponseTimeMetric metric1 = (ResponseTimeMetric)metricStore.getMetric(contextName, seqNameSpace, metricName1, MetricType.RESPONSETIME, false).getMetricData();
                    metric1.setContextName(contextName);
                    if (this.isErroneous()) {
                        metric.recordErroneousData(this.duration);
                        metric1.recordErroneousData(this.duration);
                        continue;
                    }
                    metric.recordData(this.duration);
                    metric1.recordData(this.duration);
                    continue;
                }
                catch (Exception e) {
                    String error = MessageFormat.format("Exception while generating metric for query: {0} Sequence: {1}", query, seqNameSpace);
                    JavaAgent.logger.log(Level.WARN, error, e);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String getTrackerSignature() {
        StringBuilder signature = new StringBuilder();
        signature.append(this.pointcutProperties.getComponent());
        if (this.isMetricHolded()) {
            if (this.queries.length == 1) {
                QueryInfo queryInfo = QueryParser.getQueryInfo(this.queries[0]);
                if (queryInfo != null) {
                    signature.append(" - ");
                    signature.append(queryInfo.getOperation().toUpperCase(Locale.ENGLISH));
                    signature.append(" - ");
                    signature.append(queryInfo.getTable());
                } else {
                    signature.append(" Query");
                }
            } else {
                signature.append(" - BatchQuery: ");
                signature.append(this.queries.length);
                signature.append(" Queries");
            }
        } else {
            signature.append(" Query");
        }
        if (!StringUtils.isEmptyString(this.serverAddress)) {
            signature.append(" - ");
            try {
                signature.append(this.serverAddress.split("/")[1]);
            }
            catch (Exception e) {
                signature.append(this.serverAddress);
            }
        }
        if (this.isErroneous()) {
            signature.append(" Error: ");
            signature.append(this.error.getClass().getSimpleName());
        }
        return signature.toString();
    }

    @Override
    public Map<String, Object> getMoreData(Map<String, Object> addInfo) {
        if (this.queries == null) {
            return addInfo;
        }
        String allQueries = "";
        HashSet<String> dbOperations = new HashSet<String>();
        for (String query : this.queries) {
            allQueries = allQueries + query + "<br/>";
            QueryInfo queryInfo = QueryParser.getQueryInfo(query);
            if (queryInfo == null) continue;
            dbOperations.add(queryInfo.getOperation().toUpperCase() + "/" + queryInfo.getTable());
        }
        addInfo.put("query", allQueries);
        if (!dbOperations.isEmpty()) {
            addInfo.put("db_opn", dbOperations);
        }
        if (!this.isErroneous()) {
            addInfo.put("stacktrace", new StackTrace(this.getStackTraceElement()));
        }
        return addInfo;
    }

    @Override
    public boolean isMetricHolded() {
        return this.queries != null;
    }

    public StackTraceElement[] getStackTraceElement() {
        return this.stackTraceElements;
    }

    protected boolean useOrginalQuery(String query) {
        return query.length() <= 20;
    }

    @Override
    public int hashCode() {
        return this.pointcutProperties.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return false;
    }
}

