/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.elasticsearch;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.util.InetAddressUtil;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.reflect.Method;
import java.net.URL;

public class ElasticSearchRestClientTracker
extends DefaultTracker {
    private String method;
    private String endpoint;
    private String serverAddress;

    public ElasticSearchRestClientTracker(PointcutProperties interceptPointMetaData, Object thiz, Object[] args) {
        super(interceptPointMetaData, thiz, args);
        this.isLeafTracker = true;
        if (args != null && args.length > 0) {
            this.getRequestDetails(args[0]);
        }
    }

    private void getRequestDetails(Object requestObj) {
        try {
            Class<?> reqClz = requestObj.getClass();
            Method m = reqClz.getMethod("getMethod", new Class[0]);
            this.method = m.invoke(requestObj, new Object[0]).toString();
            m = reqClz.getMethod("getEndpoint", new Class[0]);
            this.endpoint = m.invoke(requestObj, new Object[0]).toString();
        }
        catch (Exception e) {
            JavaAgent.logger.log(Level.WARN, "[ElasticSearchRestClient] Unable to extract query nature. Exception: " + e.getMessage());
        }
    }

    @Override
    public void quit(int opcode, Object respObj) {
        super.quit(opcode, respObj);
        try {
            Method m = respObj.getClass().getMethod("getHost", new Class[0]);
            Object host = m.invoke(respObj, new Object[0]);
            m = host.getClass().getMethod("toURI", new Class[0]);
            URL url = new URL((String)m.invoke(host, new Object[0]));
            this.serverAddress = url.getHost() + ":" + (url.getPort() == -1 ? url.getDefaultPort() : url.getPort());
        }
        catch (Exception e) {
            JavaAgent.logger.log(Level.WARN, "[ElasticSearchRestClient] Unable to extract host details.", e);
        }
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), InetAddressUtil.standardizeServerAddress(this.serverAddress), this.duration - childDuration, this.isErroneous());
        return true;
    }

    @Override
    public String getTrackerSignature() {
        StringBuilder signature = new StringBuilder();
        signature.append(this.pointcutProperties.getComponent().toString());
        if (this.serverAddress != null) {
            signature.append(" - ");
            signature.append(this.serverAddress);
        }
        if (this.method != null) {
            signature.append(" - ");
            signature.append(this.method);
        }
        if (this.endpoint != null) {
            signature.append(" - ");
            signature.append(this.endpoint);
        }
        if (this.isErroneous()) {
            signature.append(" Error: ");
            signature.append(this.error.getClass().getSimpleName());
        }
        return signature.toString();
    }
}

