/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.http;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.util.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class HttpParamsObfuscator {
    private static final String MASK_VALUE = "**";
    private static final String[] MASK_VALUE_1 = new String[]{"**"};
    private static final String PARAMETERS_SPLITTER = "&";
    private static final String PARAM_NAME_VALUE_SPLITTER = "=";
    private static Set<String> paramNames = Collections.emptySet();

    public static void intialize(String parameterNames) {
        if (parameterNames != null) {
            String[] parameters = parameterNames.replaceAll("\\s", "").split(",");
            paramNames = new HashSet<String>(Arrays.asList(parameters));
        }
        JavaAgent.logger.info("HttpParamsObfuscator has been initialized with values: " + paramNames);
    }

    public static void reInitialize(String params) {
        HttpParamsObfuscator.intialize(params);
    }

    public static String[] obfuscate(String paramName, String[] paramValues) {
        return paramNames.contains(paramName) ? MASK_VALUE_1 : paramValues;
    }

    public static String obfuscate(String params) {
        if (StringUtils.isEmptyString(params) || paramNames.isEmpty()) {
            return params;
        }
        String[] parameters = params.split(PARAMETERS_SPLITTER);
        StringBuffer sb = new StringBuffer();
        for (String p : parameters) {
            sb.append(PARAMETERS_SPLITTER);
            int index = p.indexOf(PARAM_NAME_VALUE_SPLITTER, 0);
            if (index == -1) {
                sb.append(p);
                continue;
            }
            String pName = p.substring(0, index).trim();
            if (paramNames.contains(pName)) {
                sb.append(pName);
                sb.append(PARAM_NAME_VALUE_SPLITTER);
                sb.append(MASK_VALUE);
                continue;
            }
            sb.append(p);
        }
        sb.deleteCharAt(0);
        return sb.toString();
    }
}

