/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.http;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.WebSeqRootTracker;
import com.manageengine.apminsight.agent.trackers.http.HttpParamsObfuscator;
import com.manageengine.apminsight.agent.util.SequenceURINormalizer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HttpPlayRequestTracker
extends WebSeqRootTracker {
    private HttpPlayRequestInfo requestInfo = null;
    private Object thisObj = null;
    private Object classLoader = null;
    private Object requestObj = null;

    public HttpPlayRequestTracker(PointcutProperties interceptPointMetaData, Object classLoder, Object controllerObj) {
        super(interceptPointMetaData, classLoder, null);
        this.classLoader = classLoder;
        this.thisObj = controllerObj;
        this.httpReq = null;
    }

    public HttpPlayRequestTracker(PointcutProperties pointcut, Object request) {
        super(pointcut, null, null);
        this.requestObj = request;
        this.httpReq = null;
    }

    @Override
    protected String assignSequenceName() {
        try {
            this.requestInfo = new HttpPlayRequestInfo(this.thisObj, (WeakReference)this.classLoader, this.requestObj);
            this.unnormalizedSeqName = this.requestInfo.httpUri;
            this.seqName = SequenceURINormalizer.normalizeURI(this.unnormalizedSeqName);
            this.httpMethod = this.requestInfo.httpMethod;
            this.thisObj = null;
            this.classLoader = null;
        }
        catch (Exception e) {
            JavaAgent.logger.warn("Unable to determine request uri. Exception: " + e);
            this.seqName = "unknown";
        }
        this.hasMetric = true;
        return this.seqName;
    }

    @Override
    public boolean isMetricHolded() {
        return this.hasMetric;
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childTrackersDuration, MetricData metricData) {
        super.generateMetric(seqHeader, childTrackersDuration, metricData);
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.duration - childTrackersDuration, this.isErroneous());
        return this.hasMetric;
    }

    @Override
    public void quit(int opcode, Object returnValue) {
        super.quit(opcode, returnValue);
        this.thisObj = null;
        this.classLoader = null;
    }

    @Override
    public void quit(Throwable th) {
        super.quit(th);
        this.thisObj = null;
        this.classLoader = null;
    }

    @Override
    public Map<String, Object> getContextualMetrics() {
        if (this.requestInfo == null) {
            return super.getContextualMetrics();
        }
        LinkedHashMap<String, Object> xtraMetrics = new LinkedHashMap<String, Object>(4, 1.0f);
        xtraMetrics.put("http_method_name", this.requestInfo.httpMethod);
        xtraMetrics.put("http_input_params", this.requestInfo.paramMap);
        return xtraMetrics;
    }

    @Override
    public int hashCode() {
        return this.pointcutProperties.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return false;
    }

    static class HttpPlayRequestInfo {
        String httpUri;
        String httpMethod;
        Map<String, List<String>> paramMap;

        HttpPlayRequestInfo(Object controllerObj, WeakReference<ClassLoader> playClassLoaderWeakRef, Object requestObj) throws Exception {
            ClassLoader playClassLoader = null;
            if (requestObj == null && controllerObj == null && (playClassLoaderWeakRef == null || (playClassLoader = (ClassLoader)playClassLoaderWeakRef.get()) == null)) {
                throw new IllegalArgumentException("all reference to request are null");
            }
            this.fillIn(controllerObj, playClassLoader, requestObj);
        }

        private void fillIn(Object thisObj, ClassLoader playClassLoader, Object requestObj) throws Exception {
            int index;
            Method method;
            Class<?> clz;
            Class[] nullParamtypes = new Class[]{};
            Object[] emptyArgs = new Object[]{};
            if (requestObj == null) {
                clz = thisObj != null ? thisObj.getClass() : playClassLoader.loadClass("play.mvc.Controller");
                method = clz.getMethod("request", nullParamtypes);
                requestObj = method.invoke(null, emptyArgs);
            }
            clz = requestObj.getClass();
            method = clz.getMethod("uri", nullParamtypes);
            this.httpUri = method.invoke(requestObj, emptyArgs).toString();
            if (this.httpUri.length() > 1 && this.httpUri.startsWith("/")) {
                this.httpUri = this.httpUri.substring(1);
            }
            this.httpUri = (index = this.httpUri.indexOf(63)) != -1 ? this.httpUri.substring(0, index) : this.httpUri;
            try {
                method = clz.getMethod("method", nullParamtypes);
                this.httpMethod = method.invoke(requestObj, emptyArgs).toString();
            }
            catch (Exception e) {
                JavaAgent.logger.warn("Couldn't able to get http method name param for sequence: " + this.httpUri);
            }
            if (!ContextInfoManager.getInstance().getDefaultContextInfo().getConfig().getWebSeqConfig().isRecordSequenceTraceInputParams()) {
                return;
            }
            try {
                method = clz.getMethod("queryString", nullParamtypes);
                Map paramMap = (Map)method.invoke(requestObj, emptyArgs);
                if (paramMap != null && !paramMap.isEmpty()) {
                    this.paramMap = new LinkedHashMap<String, List<String>>(paramMap.size());
                    for (Map.Entry entry : paramMap.entrySet()) {
                        this.paramMap.put((String)entry.getKey(), Arrays.asList(HttpParamsObfuscator.obfuscate((String)entry.getKey(), (String[])entry.getValue())));
                    }
                }
            }
            catch (Exception e) {
                JavaAgent.logger.warn("Couldn't able to get http query string param for sequence: " + this.httpUri);
            }
        }
    }
}

