/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.http;

import com.manageengine.apminsight.agent.trackers.http.ServerHttpRequest;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

public class ServletHttpRequest
implements ServerHttpRequest {
    private Object request;
    private Class requestClass;

    public ServletHttpRequest(Object requestObj) throws ClassNotFoundException {
        this.request = requestObj;
        try {
            this.requestClass = this.request.getClass().getClassLoader().loadClass("javax.servlet.http.HttpServletRequest");
        }
        catch (ClassNotFoundException e) {
            this.requestClass = this.request.getClass().getClassLoader().loadClass("jakarta.servlet.http.HttpServletRequest");
        }
    }

    @Override
    public String getRequestURL() throws Exception {
        Method m = this.requestClass.getMethod("getRequestURL", new Class[0]);
        return m.invoke(this.request, new Object[0]).toString();
    }

    @Override
    public String getRequestURI() throws Exception {
        Method m = this.requestClass.getMethod("getRequestURI", new Class[0]);
        return (String)m.invoke(this.request, new Object[0]);
    }

    @Override
    public String getContextPath() throws Exception {
        Method m = this.requestClass.getMethod("getContextPath", new Class[0]);
        return (String)m.invoke(this.request, new Object[0]);
    }

    @Override
    public String getMethod() throws Exception {
        Method m = this.requestClass.getMethod("getMethod", new Class[0]);
        return (String)m.invoke(this.request, new Object[0]);
    }

    @Override
    public String getQueryString() throws Exception {
        Method m = this.requestClass.getMethod("getQueryString", new Class[0]);
        return (String)m.invoke(this.request, new Object[0]);
    }

    @Override
    public Map getParameterMap() throws Exception {
        Method m = this.requestClass.getMethod("getParameterMap", new Class[0]);
        return (Map)m.invoke(this.request, new Object[0]);
    }

    @Override
    public String getHeader(String name) throws Exception {
        Method m = this.requestClass.getDeclaredMethod("getHeader", String.class);
        m.setAccessible(true);
        return (String)m.invoke(this.request, name);
    }

    @Override
    public List<String> getHeaderNames() throws Exception {
        Enumeration e = (Enumeration)this.requestClass.getMethod("getHeaderNames", new Class[0]).invoke(this.request, new Object[0]);
        ArrayList<String> headerNames = new ArrayList<String>();
        while (e.hasMoreElements()) {
            headerNames.add((String)e.nextElement());
        }
        return headerNames;
    }

    @Override
    public void setCharacterEncoding(String charset) throws Exception {
        Method m = this.requestClass.getMethod("setCharacterEncoding", String.class);
        m.setAccessible(true);
        m.invoke(this.request, charset);
    }

    @Override
    public long getContentLength() throws Exception {
        Method m = this.requestClass.getMethod("getContentLength", new Class[0]);
        m.setAccessible(true);
        int len = (Integer)m.invoke(this.request, new Object[0]);
        return len;
    }
}

