/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.httpclient;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.trackers.httpclient.AbstractHttpClientTracker;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class BlockingSpringWebClientTracker
extends AbstractHttpClientTracker {
    public BlockingSpringWebClientTracker(PointcutProperties pointcutProperties, Object thisObj, Object[] args, Object requestBodyUriSpecObj) {
        super(pointcutProperties, thisObj, args);
        if (requestBodyUriSpecObj != null) {
            this.httpUrl = this.getRequestUrl(requestBodyUriSpecObj);
            this.method = this.getHttpMethod(requestBodyUriSpecObj);
        }
    }

    @Override
    public void quit(int opcode, Object returnValue) {
        super.quit(opcode, returnValue);
        this.statusCode = this.getStatusCode(returnValue);
    }

    @Override
    public int getStatusCode(Object obj) {
        Class<?> clazz = obj.getClass();
        try {
            if (clazz.getSimpleName().equals("ResponseEntity")) {
                return (Integer)clazz.getMethod("getStatusCodeValue", new Class[0]).invoke(obj, new Object[0]);
            }
            if (clazz.getSimpleName().contains("ClientResponse")) {
                Method rawStatusCodeMethod = clazz.getMethod("rawStatusCode", new Class[0]);
                rawStatusCodeMethod.setAccessible(true);
                return (Integer)rawStatusCodeMethod.invoke(obj, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public String getRequestUrl(Object obj) {
        try {
            Field uriField = obj.getClass().getDeclaredField("uri");
            uriField.setAccessible(true);
            Object uriObj = uriField.get(obj);
            return (String)uriObj.getClass().getMethod("toString", new Class[0]).invoke(uriObj, new Object[0]);
        }
        catch (Exception e) {
            JavaAgent.logger.warn("[BlockingSpringWebClientTracker] Exception occurred fetching request url. " + e.getMessage());
            return null;
        }
    }

    @Override
    public String getHttpMethod(Object obj) {
        try {
            Field httpMethodField = obj.getClass().getDeclaredField("httpMethod");
            httpMethodField.setAccessible(true);
            Object httpMethodObj = httpMethodField.get(obj);
            return (String)httpMethodObj.getClass().getMethod("name", new Class[0]).invoke(httpMethodObj, new Object[0]);
        }
        catch (Exception e) {
            JavaAgent.logger.warn("[BlockingSpringWebClientTracker] Exception occurred fetching request method. " + e.getMessage());
            return null;
        }
    }

    @Override
    public void setDTHeaderInRequest(Object obj) {
    }

    @Override
    public String getDTHeaderFromResponse(Object obj) {
        return null;
    }
}

