/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.httpclient;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.trackers.httpclient.HttpURLConnectionTracker;
import com.manageengine.apminsight.agent.util.InetAddressUtil;
import com.manageengine.org.apache.logging.log4j.Level;
import com.manageengine.org.json.simple.JSONValue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;

public class HTTPTrackerGroup
extends DefaultTracker {
    protected String httpMethod;
    protected String httpUrl;
    protected String dtData;
    protected int statusCode = 0;
    protected boolean isDTHeaderSet = false;
    protected boolean isDTResponseHeaderExtracted = false;
    protected WeakReference<URLConnection> connectionObj;

    public HTTPTrackerGroup(PointcutProperties pointcutProperties, Object thiz, Object[] args) {
        super(pointcutProperties, thiz, args);
        this.isLeafTracker = true;
    }

    protected void addDuration() {
        this.quit();
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        if (this.dtData == null && this.isDTHeaderSet && !this.isDTResponseHeaderExtracted) {
            this.dtData = this.tryFailBackToGetDtData();
            this.isDTResponseHeaderExtracted = true;
        }
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.extractServerAddress(this.httpUrl), this.extractInstanceIdFromDtData(), this.duration - childDuration, this.isErroneous());
        return true;
    }

    private String tryFailBackToGetDtData() {
        if (this.connectionObj != null) {
            return HttpURLConnectionTracker.getHeader((URLConnection)this.connectionObj.get(), "X-Site24x7-DT-Data");
        }
        return null;
    }

    private String extractInstanceIdFromDtData() {
        if (this.dtData != null) {
            try {
                Map data = (Map)JSONValue.parse(this.dtData);
                return (String)data.get("instance_id");
            }
            catch (Exception e) {
                JavaAgent.logger.warn("[AbstractHttpClient] Unable to fetch instance id from DTdata. " + e.getMessage());
            }
        }
        return null;
    }

    private String extractServerAddress(String httpUrl) {
        if (httpUrl == null) {
            return null;
        }
        String address = null;
        if (JavaAgentConfig.captureHostDetails) {
            try {
                URL url = new URL(httpUrl);
                address = url.getHost() + ":" + (url.getPort() != -1 ? url.getPort() : url.getDefaultPort());
                address = InetAddressUtil.standardizeServerAddress(address);
            }
            catch (Throwable th) {
                JavaAgent.logger.log(Level.WARN, "[AbstractHttpClientTracker] Unable to extract server address from URL: " + httpUrl + " Exception: " + th.getMessage());
                address = null;
            }
        }
        return address;
    }

    @Override
    public Map<String, Object> getMoreData(Map<String, Object> moreData) {
        if (this.dtData != null) {
            Map data = (Map)JSONValue.parse(this.dtData);
            moreData.put("dtdata", data);
        }
        return moreData;
    }

    @Override
    public String getTrackerSignature() {
        if (this.httpUrl == null) {
            return super.getTrackerSignature();
        }
        StringBuffer signature = new StringBuffer();
        if (this.httpMethod != null) {
            signature.append(this.httpMethod.toUpperCase());
            signature.append(" - ");
        }
        if (this.statusCode > 0) {
            signature.append(this.statusCode);
            signature.append(" - ");
        }
        signature.append(this.httpUrl);
        if (this.isErroneous()) {
            signature.append(" Error: " + this.error.getClass().getSimpleName());
        }
        return signature.toString();
    }
}

