/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.httpclient;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.trackers.VoidTracker;
import com.manageengine.apminsight.agent.trackers.httpclient.HTTPTrackerGroup;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URLConnection;

public class HttpURLConnectionTracker
extends DefaultTracker
implements VoidTracker {
    private URLConnection connection;
    private HTTPTrackerGroup leadTracker;

    public HttpURLConnectionTracker(HTTPTrackerGroup leadTracker, PointcutProperties pointcutProperties, Object thiz, Object[] args) {
        super(pointcutProperties, thiz, args);
        this.leadTracker = leadTracker;
        this.connection = (URLConnection)thiz;
        this.getRequestUrl(thiz);
        this.getHttpMethod(thiz);
        if (pointcutProperties.getInterceptedMethodName().matches("connect|getInputStream|getOutputStream")) {
            this.setDTHeaderInRequest();
        }
    }

    @Override
    public void quit(int opcode, Object returnValue) {
        super.quit(opcode, returnValue);
        if (this.pointcutProperties.getInterceptedMethodName().matches("getResponseCode")) {
            this.getDTHeaderFromResponse();
        } else if (this.pointcutProperties.getInterceptedMethodName().matches("getInputStream")) {
            this.leadTracker.connectionObj = new WeakReference<URLConnection>(this.connection);
        }
        this.connection = null;
    }

    @Override
    protected void quit() {
        super.quit();
        this.leadTracker.addDuration();
    }

    private void getRequestUrl(Object requestObject) {
        if (this.leadTracker.httpUrl == null) {
            this.leadTracker.httpUrl = ((HttpURLConnection)requestObject).getURL().toString();
        }
    }

    private void getHttpMethod(Object requestObject) {
        if (this.leadTracker.httpMethod == null) {
            this.leadTracker.httpMethod = ((HttpURLConnection)requestObject).getRequestMethod();
        }
    }

    private void setDTHeaderInRequest() {
        if (!this.leadTracker.isDTHeaderSet) {
            try {
                Field field = URLConnection.class.getDeclaredField("connected");
                field.setAccessible(true);
                boolean isConnected = (Boolean)field.get(this.connection);
                SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
                if (!isConnected && seqSpace.currentTrackersCount() != 0 && seqSpace.getConfig().isDistributedTracingEnabled()) {
                    this.connection.setRequestProperty("X-Site24x7-Id", JavaAgent.getInstance().agentConfig.getDistributedTracingId());
                    this.leadTracker.isDTHeaderSet = true;
                    JavaAgent.logger.debug("[DistributedTracing] Outgoing request id added to header " + this.leadTracker.httpUrl);
                }
            }
            catch (Throwable th) {
                JavaAgent.logger.log(Level.WARN, "[HttpUrlConnection] Error including distributed tracing id in request header. Exception: " + th.getMessage());
            }
        }
    }

    private String getDTHeaderFromResponse() {
        if (this.leadTracker.isDTHeaderSet && !this.leadTracker.isDTResponseHeaderExtracted) {
            this.leadTracker.dtData = HttpURLConnectionTracker.getHeader(this.connection, "X-Site24x7-DT-Data");
            this.leadTracker.isDTResponseHeaderExtracted = true;
            JavaAgent.logger.trace("[DistributedTracing] Incoming response, url " + this.leadTracker.httpUrl + " DT-DATA:" + this.leadTracker.dtData);
        }
        return this.leadTracker.dtData;
    }

    public static String getHeader(URLConnection connectionObj, String headerName) {
        return connectionObj.getHeaderField(headerName);
    }
}

