/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.httpclient;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.trackers.httpclient.AbstractHttpClientTracker;
import java.lang.reflect.Method;

public class OkHttpClientTracker
extends AbstractHttpClientTracker {
    public OkHttpClientTracker(PointcutProperties pointcutProperties, Object thiz, Object[] args) {
        super(pointcutProperties, thiz, args);
        try {
            Method m = thiz.getClass().getMethod("request", new Class[0]);
            m.setAccessible(true);
            Object request = m.invoke(thiz, new Object[0]);
            this.httpUrl = this.getRequestUrl(request);
            this.method = this.getHttpMethod(request);
        }
        catch (Exception e) {
            JavaAgent.logger.warn("[OkHttpCLient] Unable to get request details. Exception: " + e.getCause());
        }
    }

    @Override
    public void quit(int opcode, Object returnValue) {
        super.quit(opcode, returnValue);
        this.statusCode = this.getStatusCode(returnValue);
    }

    @Override
    public String getRequestUrl(Object requestObject) {
        try {
            Method m = requestObject.getClass().getMethod("url", new Class[0]);
            m.setAccessible(true);
            return m.invoke(requestObject, new Object[0]).toString();
        }
        catch (Exception e) {
            return this.httpUrl;
        }
    }

    @Override
    public String getHttpMethod(Object requestObject) {
        try {
            Method m = requestObject.getClass().getMethod("method", new Class[0]);
            m.setAccessible(true);
            return m.invoke(requestObject, new Object[0]).toString();
        }
        catch (Exception e) {
            return this.method;
        }
    }

    @Override
    public int getStatusCode(Object respObj) {
        try {
            Method m = respObj.getClass().getMethod("code", new Class[0]);
            m.setAccessible(true);
            return (Integer)m.invoke(respObj, new Object[0]);
        }
        catch (Exception e) {
            return this.statusCode;
        }
    }

    @Override
    public void setDTHeaderInRequest(Object requestObject) {
    }

    @Override
    public String getDTHeaderFromResponse(Object respObj) {
        return null;
    }
}

