/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.messaging;

import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.util.InetAddressUtil;

public class MessagingTracker
extends DefaultTracker {
    private String serverInfo;
    private Object clientObj;

    public MessagingTracker(String serverInfo, PointcutProperties pointcutProperties, Object clientObj, Object[] args) {
        super(pointcutProperties, clientObj, args);
        this.serverInfo = serverInfo;
        this.clientObj = clientObj;
        this.isLeafTracker = true;
    }

    @Override
    public String getTrackerSignature() {
        StringBuilder signature = new StringBuilder(this.pointcutProperties.getComponent().toString());
        signature.append(this.serverInfo != null ? " - " + (this.serverInfo.contains("/") ? this.serverInfo.split("/")[1] : this.serverInfo) : "").append(" - " + this.pointcutProperties.getInterceptedMethodName().toUpperCase()).append(this.isErroneous() ? " - Error: " + this.error.getClass().getSimpleName() : "");
        return signature.toString();
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        this.serverInfo = InetAddressUtil.standardizeServerAddress(this.serverInfo);
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.serverInfo, this.duration - childDuration, this.isErroneous());
        return true;
    }

    @Override
    protected void quit() {
        super.quit();
        this.clientObj = null;
    }

    public Object getClientObj() {
        return this.clientObj;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(String serverInfo) {
        this.serverInfo = serverInfo;
    }
}

