/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentWeakDictionary<K, V> {
    Fragment<K, V>[] fragments;
    static final int MAX_CONCURRENCY_LEVEL = 65536;
    int fragmentShift;
    int fragmentMask;

    public ConcurrentWeakDictionary(int initialCap, float loadFactor, int concurrencyLevel) {
        int fragmentCapacity;
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int partition = 1;
        int partitionShift = 0;
        while (partition < concurrencyLevel) {
            partition <<= 1;
            ++partitionShift;
        }
        this.fragmentShift = 32 - partitionShift;
        this.fragmentMask = partition - 1;
        this.fragments = new Fragment[partition];
        int roughCapacity = initialCap / partition;
        if (roughCapacity * partition < initialCap) {
            ++roughCapacity;
        }
        for (fragmentCapacity = 1; fragmentCapacity < roughCapacity; fragmentCapacity <<= 1) {
        }
        for (int i = 0; i < partition; ++i) {
            this.fragments[i] = new Fragment(fragmentCapacity, loadFactor);
        }
    }

    public V put(K key, V value) {
        if (key == null) {
            return null;
        }
        int hash = ConcurrentWeakDictionary.hash(key);
        return this.getFragment(hash).put(key, value, hash, false);
    }

    public boolean putIfNotExists(K key, V value) {
        if (key == null) {
            return false;
        }
        int hash = ConcurrentWeakDictionary.hash(key);
        return this.getFragment(hash).put(key, value, hash, true) == null;
    }

    public V get(Object key) {
        if (key == null) {
            return null;
        }
        int hash = ConcurrentWeakDictionary.hash(key);
        return this.getFragment(hash).get(key, hash);
    }

    public V remove(Object key) {
        int hash = ConcurrentWeakDictionary.hash(key);
        return this.getFragment(hash).remove(key, hash);
    }

    Fragment<K, V> getFragment(int hash) {
        return this.fragments[hash >>> this.fragmentShift & this.fragmentMask];
    }

    static int hash(Object x) {
        int h = x.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    public int size() {
        int size = 0;
        for (int i = this.fragments.length - 1; i >= 0; --i) {
            size += this.fragments[i].count;
        }
        return size;
    }

    public boolean remove(Object key, Object value) {
        return this.remove(key) != null;
    }

    public void clear() {
        for (int i = this.fragments.length; i >= 0; --i) {
            this.fragments[i].clear();
        }
    }

    public String toString() {
        return Arrays.deepToString(this.fragments);
    }

    static final class Element<K, V>
    extends WeakReference<K> {
        V value;
        int hash;
        Element<K, V> next;

        Element(K key, V value, int hash, ReferenceQueue<K> queue) {
            super(key, queue);
            this.hash = hash;
            this.value = value;
            this.next = null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Element<K, V> next = this;
            while (next != null) {
                sb.append(next.get());
                sb.append(':');
                sb.append(next.value);
                sb.append(';');
                next = next.next;
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
    }

    static final class Fragment<K, V> {
        ReferenceQueue<K> refQ;
        ReentrantLock locker;
        Element<K, V>[] elements;
        int count;
        int threshold;
        float loadFactor;
        static int ROOM_INCREMENT_SLAB = 1;

        Fragment(int initalCap, float loadFactor) {
            this.elements = new Element[initalCap];
            this.loadFactor = loadFactor;
            this.threshold = (int)((float)initalCap * loadFactor);
            this.count = 0;
            this.refQ = new ReferenceQueue();
            this.locker = new ReentrantLock(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K key, V value, int keyHash, boolean putIfNotExists) {
            this.locker.lock();
            try {
                this.wipeoutStaleElements();
                if (this.count + 1 >= this.threshold) {
                    this.makeRoom(this.elements.length << ROOM_INCREMENT_SLAB);
                }
                int index = this.computeIndex(keyHash, this.elements.length - 1);
                Element<K, V> existingEle = this.elements[index];
                while (existingEle != null) {
                    if (keyHash == existingEle.hash && this.checkEq(key, existingEle.get())) {
                        Object oldValue = existingEle.value;
                        if (!putIfNotExists) {
                            existingEle.value = value;
                        }
                        Object v = oldValue;
                        return v;
                    }
                    existingEle = existingEle.next;
                }
                Element<K, V> element = new Element<K, V>(key, value, keyHash, this.refQ);
                element.next = this.elements[index];
                ++this.count;
                this.elements[index] = element;
                V v = null;
                return v;
            }
            finally {
                this.locker.unlock();
            }
        }

        V get(Object key, int hash) {
            if (this.count == 0) {
                return null;
            }
            Element<K, V>[] elements = this.elements;
            int index = this.computeIndex(hash, elements.length - 1);
            Element<K, V> e = elements[index];
            while (e != null) {
                if (hash == e.hash && this.checkEq(key, e.get())) {
                    return e.value;
                }
                e = e.next;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object key, int hash) {
            if (this.count == 0) {
                return null;
            }
            this.locker.lock();
            try {
                Element<K, V> e;
                int index = this.computeIndex(hash, this.elements.length - 1);
                Element<K, V> prev = e = this.elements[index];
                while (e != null) {
                    if (hash == e.hash && this.checkEq(key, e.get())) {
                        if (prev == e) {
                            this.elements[index] = e.next;
                        } else {
                            prev.next = e.next;
                        }
                        --this.count;
                        Object v = e.value;
                        return v;
                    }
                    prev = e;
                    e = e.next;
                }
                V v = null;
                return v;
            }
            finally {
                this.locker.unlock();
            }
        }

        void clear() {
            if (this.count == 0) {
                return;
            }
            this.locker.lock();
            try {
                for (int i = this.elements.length; i >= 0; --i) {
                    this.elements[i] = null;
                }
                this.count = 0;
            }
            finally {
                this.locker.unlock();
            }
        }

        void makeRoom(int newCapacity) {
            Element[] elements = new Element[newCapacity];
            this.transferData(this.elements, elements);
            this.threshold = (int)(this.loadFactor * (float)newCapacity);
            this.elements = elements;
        }

        void transferData(Element<K, V>[] src, Element<K, V>[] dest) {
            int mask = dest.length - 1;
            for (int i = src.length - 1; i >= 0; --i) {
                Element<K, V> e = src[i];
                while (e != null) {
                    int index = this.computeIndex(e.hash, mask);
                    Element next = e.next;
                    e.next = dest[index];
                    dest[index] = e;
                    e = next;
                }
            }
        }

        void wipeoutStaleElements() {
            Element qElement;
            Element<K, V>[] elements = this.elements;
            int size = this.count;
            int mask = elements.length - 1;
            block0: while ((qElement = (Element)this.refQ.poll()) != null) {
                Element<K, V> ele;
                int index = this.computeIndex(qElement.hash, mask);
                Element<K, V> prev = ele = elements[index];
                while (ele != null) {
                    Element next = ele.next;
                    if (ele == qElement) {
                        if (prev == ele) {
                            elements[index] = next;
                        } else {
                            prev.next = next;
                        }
                        --size;
                        ele.value = null;
                        ele.next = null;
                        continue block0;
                    }
                    prev = ele;
                    ele = ele.next;
                }
            }
            this.count = size;
            this.elements = elements;
        }

        int computeIndex(int hash, int mask) {
            return hash & mask;
        }

        boolean checkEq(Object o1, Object o2) {
            if (o1 == null || o2 == null) {
                return false;
            }
            return o1 == o2 ? true : o1.equals(o2);
        }

        public String toString() {
            return Arrays.deepToString(this.elements);
        }
    }
}

