/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.util;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static final String EMPTY_STRING = "";
    public static final String SOME_STRING = "heHe";

    public static boolean isEmptyString(String ... strings) {
        for (String s : strings) {
            if (!StringUtils.isEmptyString(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmptyString(String s) {
        return s == null || s.trim().equals(EMPTY_STRING) || s.trim().equalsIgnoreCase("null");
    }

    public static String formatString(String s, Pattern pattern, Object[] values) {
        StringBuffer sb = new StringBuffer();
        Matcher m = pattern.matcher(s);
        while (m.find()) {
            int idx = -1;
            idx = Integer.parseInt(m.group(1));
            m.appendReplacement(sb, idx < values.length ? String.valueOf(values[idx]) : "{" + idx + "}");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String trim(String s) {
        if (s == null) {
            return EMPTY_STRING;
        }
        return s.trim();
    }

    public static String removeAllWhiteSpaces(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        return str.replaceAll("\\s+", EMPTY_STRING);
    }

    public static long getAsLong(String s) {
        return StringUtils.isEmptyString(s) ? -1L : new BigDecimal(s).longValue();
    }

    public static long getAsLong(Object o) {
        return o == null ? -1L : StringUtils.getAsLong(o.toString());
    }

    public static int getAsInteger(String s) {
        return StringUtils.isEmptyString(s) ? -1 : new BigDecimal(s).intValue();
    }

    public static int getAsInteger(Object o) {
        return o == null ? -1 : StringUtils.getAsInteger(o.toString());
    }

    public static float getAsFloat(String s) {
        return StringUtils.isEmptyString(s) ? -1.0f : Float.parseFloat(s);
    }

    public static Float getAsFloat(Object o) {
        return o == null ? null : Float.valueOf(StringUtils.getAsFloat(o.toString()));
    }

    public static Double getAsDouble(String s) {
        return StringUtils.isEmptyString(s) ? -1.0 : Double.parseDouble(s);
    }

    public static Double getAsDouble(Object o) {
        return o == null ? null : StringUtils.getAsDouble(o.toString());
    }

    public static String getAsCSV(Object[] objects, boolean quote) {
        if (objects == null || objects.length == 0) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : objects) {
            if (o == null) continue;
            if (quote) {
                StringUtils.wrapWithQuote(sb, o.toString());
            } else {
                sb.append(o.toString());
            }
            sb.append(',');
        }
        StringUtils.removeLastChar(sb, ',');
        return sb.toString();
    }

    public static void wrapWithQuote(StringBuilder sb, String s) {
        sb.append('\'').append(s).append('\'');
    }

    public static void removeLastChar(StringBuilder sb, char c) {
        if (sb.charAt(sb.length() - 1) == c) {
            sb.deleteCharAt(sb.length() - 1);
        }
    }

    public static Long[] getAsLongArrayFromCSV(String data) {
        return StringUtils.convertToLongArray(StringUtils.getAsArrayFromCSV(data));
    }

    public static Long[] convertToLongArray(String[] dataItems) {
        Long[] longArray = new Long[dataItems.length];
        int itemsIterator = 0;
        for (String dataItem : dataItems) {
            longArray[itemsIterator++] = Long.parseLong(dataItem);
        }
        return longArray;
    }

    public static String[] getAsArrayFromCSV(String data) {
        return data.split(",");
    }

    public static String[] convertToStringArray(Long[] dataItems) {
        String[] stringArray = new String[dataItems.length];
        int itemsIterator = 0;
        for (Long dataItem : dataItems) {
            stringArray[itemsIterator++] = String.valueOf(dataItem);
        }
        return stringArray;
    }

    public static String removeProtocol(String urlAsString) {
        urlAsString = urlAsString + " ";
        String[] split = urlAsString.split("://");
        return split[split.length - 1].trim();
    }

    public static String efficientTrim(String str) {
        return str.trim() + EMPTY_STRING;
    }
}

