/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.util;

import java.util.concurrent.ThreadLocalRandom;

public class UUIDGenerator {
    public static String generateTraceID() {
        return UUIDGenerator.generateRandom();
    }

    public static String generateSpanID() {
        return UUIDGenerator.generateRandom().substring(0, 16);
    }

    private static String generateRandom() {
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        return new UniqueID(threadLocalRandom.nextLong(), threadLocalRandom.nextLong()).toString();
    }

    private static final class UniqueID {
        private final long mostSigBits;
        private final long leastSigBits;

        public UniqueID(long msb, long lsb) {
            this.mostSigBits = msb;
            this.leastSigBits = lsb;
        }

        public String toString() {
            return this.digits(this.mostSigBits >> 32, 8) + this.digits(this.mostSigBits >> 16, 4) + this.digits(this.mostSigBits, 4) + this.digits(this.leastSigBits >> 48, 4) + this.digits(this.leastSigBits, 12);
        }

        private String digits(long longBits, int length) {
            long l = 1L << length * 4;
            return Long.toHexString(l | longBits & l - 1L).substring(1);
        }
    }
}

