/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.org.apache.logging.log4j.core.config;

import com.manageengine.org.apache.logging.log4j.core.LogEvent;
import com.manageengine.org.apache.logging.log4j.core.config.Configuration;
import com.manageengine.org.apache.logging.log4j.core.config.Property;
import com.manageengine.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.manageengine.org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import com.manageengine.org.apache.logging.log4j.core.config.plugins.PluginElement;
import com.manageengine.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import com.manageengine.org.apache.logging.log4j.core.lookup.Interpolator;
import com.manageengine.org.apache.logging.log4j.core.lookup.LookupResult;
import com.manageengine.org.apache.logging.log4j.core.lookup.PropertiesLookup;
import com.manageengine.org.apache.logging.log4j.core.lookup.StrLookup;
import com.manageengine.org.apache.logging.log4j.core.lookup.StrSubstitutor;

@Plugin(name="properties", category="Core", printObject=true)
public final class PropertiesPlugin {
    private static final StrSubstitutor UNESCAPING_SUBSTITUTOR = PropertiesPlugin.createUnescapingSubstitutor();

    private PropertiesPlugin() {
    }

    @PluginFactory
    public static StrLookup configureSubstitutor(@PluginElement(value="Properties") Property[] properties, @PluginConfiguration Configuration config) {
        Property[] unescapedProperties = new Property[properties == null ? 0 : properties.length];
        for (int i = 0; i < unescapedProperties.length; ++i) {
            unescapedProperties[i] = PropertiesPlugin.unescape(properties[i]);
        }
        return new Interpolator(new PropertiesLookup(unescapedProperties, config.getProperties()), config.getPluginPackages());
    }

    private static Property unescape(Property input) {
        return Property.createProperty(input.getName(), PropertiesPlugin.unescape(input.getRawValue()), input.getValue());
    }

    static String unescape(String input) {
        return UNESCAPING_SUBSTITUTOR.replace(input);
    }

    private static StrSubstitutor createUnescapingSubstitutor() {
        StrSubstitutor substitutor = new StrSubstitutor(NullLookup.INSTANCE);
        substitutor.setValueDelimiter(null);
        substitutor.setValueDelimiterMatcher(null);
        return substitutor;
    }

    private static enum NullLookup implements StrLookup
    {
        INSTANCE;


        @Override
        public String lookup(String key) {
            return null;
        }

        @Override
        public String lookup(LogEvent event, String key) {
            return null;
        }

        @Override
        public LookupResult evaluate(String key) {
            return null;
        }

        @Override
        public LookupResult evaluate(LogEvent event, String key) {
            return null;
        }
    }
}

