/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.org.apache.logging.log4j.core.pattern;

import com.manageengine.org.apache.logging.log4j.core.LogEvent;
import com.manageengine.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.manageengine.org.apache.logging.log4j.core.pattern.ConverterKeys;
import com.manageengine.org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import com.manageengine.org.apache.logging.log4j.util.PerformanceSensitive;
import java.lang.management.ManagementFactory;

@Plugin(name="RelativeTimePatternConverter", category="Converter")
@ConverterKeys(value={"r", "relative"})
@PerformanceSensitive(value={"allocation"})
public class RelativeTimePatternConverter
extends LogEventPatternConverter {
    private final long startTime = ManagementFactory.getRuntimeMXBean().getStartTime();

    public RelativeTimePatternConverter() {
        super("Time", "time");
    }

    public static RelativeTimePatternConverter newInstance(String[] options) {
        return new RelativeTimePatternConverter();
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        long timestamp = event.getTimeMillis();
        toAppendTo.append(timestamp - this.startTime);
    }
}

