/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.org.bouncycastle.pqc.jcajce.provider.mceliece;

import com.manageengine.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.manageengine.org.bouncycastle.asn1.ASN1Primitive;
import com.manageengine.org.bouncycastle.asn1.DERNull;
import com.manageengine.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.manageengine.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.manageengine.org.bouncycastle.crypto.CipherParameters;
import com.manageengine.org.bouncycastle.pqc.asn1.McEliecePrivateKey;
import com.manageengine.org.bouncycastle.pqc.crypto.mceliece.McElieceParameters;
import com.manageengine.org.bouncycastle.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import com.manageengine.org.bouncycastle.pqc.jcajce.spec.McEliecePrivateKeySpec;
import com.manageengine.org.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.manageengine.org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.manageengine.org.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.manageengine.org.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.io.IOException;
import java.security.PrivateKey;

public class BCMcEliecePrivateKey
implements CipherParameters,
PrivateKey {
    private static final long serialVersionUID = 1L;
    private String oid;
    private int n;
    private int k;
    private GF2mField field;
    private PolynomialGF2mSmallM goppaPoly;
    private GF2Matrix sInv;
    private Permutation p1;
    private Permutation p2;
    private GF2Matrix h;
    private PolynomialGF2mSmallM[] qInv;
    private McElieceParameters mcElieceParams;

    public BCMcEliecePrivateKey(String string, int n, int n2, GF2mField gF2mField, PolynomialGF2mSmallM polynomialGF2mSmallM, GF2Matrix gF2Matrix, Permutation permutation, Permutation permutation2, GF2Matrix gF2Matrix2, PolynomialGF2mSmallM[] polynomialGF2mSmallMArray) {
        this.oid = string;
        this.n = n;
        this.k = n2;
        this.field = gF2mField;
        this.goppaPoly = polynomialGF2mSmallM;
        this.sInv = gF2Matrix;
        this.p1 = permutation;
        this.p2 = permutation2;
        this.h = gF2Matrix2;
        this.qInv = polynomialGF2mSmallMArray;
    }

    public BCMcEliecePrivateKey(McEliecePrivateKeySpec mcEliecePrivateKeySpec) {
        this(mcEliecePrivateKeySpec.getOIDString(), mcEliecePrivateKeySpec.getN(), mcEliecePrivateKeySpec.getK(), mcEliecePrivateKeySpec.getField(), mcEliecePrivateKeySpec.getGoppaPoly(), mcEliecePrivateKeySpec.getSInv(), mcEliecePrivateKeySpec.getP1(), mcEliecePrivateKeySpec.getP2(), mcEliecePrivateKeySpec.getH(), mcEliecePrivateKeySpec.getQInv());
    }

    public BCMcEliecePrivateKey(McEliecePrivateKeyParameters mcEliecePrivateKeyParameters) {
        this(mcEliecePrivateKeyParameters.getOIDString(), mcEliecePrivateKeyParameters.getN(), mcEliecePrivateKeyParameters.getK(), mcEliecePrivateKeyParameters.getField(), mcEliecePrivateKeyParameters.getGoppaPoly(), mcEliecePrivateKeyParameters.getSInv(), mcEliecePrivateKeyParameters.getP1(), mcEliecePrivateKeyParameters.getP2(), mcEliecePrivateKeyParameters.getH(), mcEliecePrivateKeyParameters.getQInv());
        this.mcElieceParams = mcEliecePrivateKeyParameters.getParameters();
    }

    public String getAlgorithm() {
        return "McEliece";
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    public GF2mField getField() {
        return this.field;
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return this.goppaPoly;
    }

    public GF2Matrix getSInv() {
        return this.sInv;
    }

    public Permutation getP1() {
        return this.p1;
    }

    public Permutation getP2() {
        return this.p2;
    }

    public GF2Matrix getH() {
        return this.h;
    }

    public PolynomialGF2mSmallM[] getQInv() {
        return this.qInv;
    }

    public String getOIDString() {
        return this.oid;
    }

    public String toString() {
        String string = " length of the code          : " + this.n + "\n";
        string = string + " dimension of the code       : " + this.k + "\n";
        string = string + " irreducible Goppa polynomial: " + this.goppaPoly + "\n";
        string = string + " (k x k)-matrix S^-1         : " + this.sInv + "\n";
        string = string + " permutation P1              : " + this.p1 + "\n";
        string = string + " permutation P2              : " + this.p2;
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCMcEliecePrivateKey)) {
            return false;
        }
        BCMcEliecePrivateKey bCMcEliecePrivateKey = (BCMcEliecePrivateKey)object;
        return this.n == bCMcEliecePrivateKey.n && this.k == bCMcEliecePrivateKey.k && this.field.equals(bCMcEliecePrivateKey.field) && this.goppaPoly.equals(bCMcEliecePrivateKey.goppaPoly) && this.sInv.equals(bCMcEliecePrivateKey.sInv) && this.p1.equals(bCMcEliecePrivateKey.p1) && this.p2.equals(bCMcEliecePrivateKey.p2) && this.h.equals(bCMcEliecePrivateKey.h);
    }

    public int hashCode() {
        return this.k + this.n + this.field.hashCode() + this.goppaPoly.hashCode() + this.sInv.hashCode() + this.p1.hashCode() + this.p2.hashCode() + this.h.hashCode();
    }

    protected ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier("1.3.6.1.4.1.8301.3.1.3.4.1");
    }

    protected ASN1Primitive getAlgParams() {
        return null;
    }

    public byte[] getEncoded() {
        PrivateKeyInfo privateKeyInfo;
        Object object;
        McEliecePrivateKey mcEliecePrivateKey = new McEliecePrivateKey(new ASN1ObjectIdentifier(this.oid), this.n, this.k, this.field, this.goppaPoly, this.sInv, this.p1, this.p2, this.h, this.qInv);
        try {
            object = new AlgorithmIdentifier(this.getOID(), DERNull.INSTANCE);
            privateKeyInfo = new PrivateKeyInfo((AlgorithmIdentifier)object, mcEliecePrivateKey);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        try {
            object = privateKeyInfo.getEncoded();
            return object;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public String getFormat() {
        return null;
    }

    public McElieceParameters getMcElieceParameters() {
        return this.mcElieceParams;
    }
}

