#!/bin/sh
SCRIPT_DIR="$(dirname "$0")"

PACKAGE_NAME="AgentPHP"
INSTALLER_NAME="${PACKAGE_NAME}Installer"

GrantPermission() {
	chmod 777 "${SCRIPT_DIR}/../../zpa" -R
}

version() {
    cat "${SCRIPT_DIR}/version"
}

install() {
    echo "Action: Installing ${PACKAGE_NAME}"

    "${SCRIPT_DIR}/${INSTALLER_NAME}" "$@" 

    echo "Status: Installation process completed"
}

uninstall() {
    echo "Action: Uninstalling ${PACKAGE_NAME}"

    "${SCRIPT_DIR}/${INSTALLER_NAME}" "$@"
    
    echo "Status: Uninstallation process completed"
}

configure() {
    echo "Action: Updating INI Configurations"

    "${SCRIPT_DIR}/${INSTALLER_NAME}" "$@"
    
    echo "Status: Updated INI configurations"
}

GrantPermission

case "${1}" in 
    version)
        version
        ;;
    install)
        install "$@"
        ;;  
    uninstall)
        uninstall "$@"
        ;;    
    configure)
        configure "$@"
        ;;       
    *)
    echo "Operation [${1}] not supported"
    exit 1
    ;;
esac




