#!/bin/sh
PRODUCT_INFO=appmanager
PACKAGE_NAME=AppManagerDataExporter

. "/opt/${PACKAGE_NAME}/bin/service.env"

start() {
    if [ "$USER_TYPE" = $ROOT_USER ]; then
        sh "/opt/${PACKAGE_NAME}/bin/service.sh" service_start -q
    else
        su "${PRODUCT_INFO}-user" -c "sh /opt/${PACKAGE_NAME}/bin/service.sh service_start -q"
    fi
}

stop() {
    if [ "$USER_TYPE" = $ROOT_USER ]; then
        sh "/opt/${PACKAGE_NAME}/bin/service.sh" service_stop -q
    else
        su "${PRODUCT_INFO}-user" -c "sh /opt/${PACKAGE_NAME}/bin/service.sh service_stop -q"
    fi
}

restart() {
    if [ "$USER_TYPE" = $ROOT_USER ]; then
        sh "/opt/${PACKAGE_NAME}/bin/service.sh" service_stop -q
        sh "/opt/${PACKAGE_NAME}/bin/service.sh" service_start -q
    else
        su "${PRODUCT_INFO}-user" -c "sh /opt/${PACKAGE_NAME}/bin/service.sh service_stop -q"
        su "${PRODUCT_INFO}-user" -c "sh /opt/${PACKAGE_NAME}/bin/service.sh service_start -q"
    fi
}

status() {
    if [ "$USER_TYPE" = $ROOT_USER ]; then
        sh "/opt/${PACKAGE_NAME}/bin/service.sh service_status -q"
        cmdstatus=$?
        if [ "$cmdstatus" -eq 0 ]; then
            echo "${PACKAGE_NAME} is in running state"
        else
            echo "${PACKAGE_NAME} is in stopped state"
        fi
    else
        su "${PRODUCT_INFO}-user" -c "/opt/${PACKAGE_NAME}/bin/service.sh service_status -q"
        cmdstatus=$?
        if [ "$cmdstatus" -eq 0 ]; then
            echo "${PACKAGE_NAME} is in running state"
        else
            echo "${PACKAGE_NAME} is in stopped state"
        fi
    fi 
}

case "${1}" in 
    start)
        start
        ;;
    stop)
        stop
        ;;
    restart)
        restart
        ;;
    status)
        status
        ;;  
    *)
        echo "Operation [${1}] not supported"
        exit 1
        ;;
esac
