/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent;

import com.manageengine.apminsight.agent.AgentState;
import com.manageengine.apminsight.agent.CommandLineArgsParser;
import com.manageengine.apminsight.agent.JavaAgentConstants;
import com.manageengine.apminsight.agent.JavaAgentHandler;
import com.manageengine.apminsight.agent.autoupgrade.AgentUpgrader;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.context.ContextInfo;
import com.manageengine.apminsight.agent.exception.FatalException;
import com.manageengine.apminsight.agent.instrumentation.ClassRetransformationEngine;
import com.manageengine.apminsight.agent.instrumentation.ClassTransformer;
import com.manageengine.apminsight.agent.instrumentation.Log4j2PluginPreloadingClassTransformer;
import com.manageengine.apminsight.agent.logging.AgentLogger;
import com.manageengine.apminsight.agent.logging.LoggingConfig;
import com.manageengine.apminsight.agent.metrics.store.MetricStore;
import com.manageengine.apminsight.agent.metrics.store.MetricStoreController;
import com.manageengine.apminsight.agent.sequence.SequenceHeaderQueue;
import com.manageengine.apminsight.agent.sequence.SequenceTraceStore;
import com.manageengine.apminsight.agent.service.JavaAgentService;
import com.manageengine.apminsight.agent.thread.WorkerThreadFactory;
import com.manageengine.apminsight.agent.util.FileUtil;
import com.manageengine.apminsight.agent.util.JavaAgentUtil;
import com.manageengine.apminsight.agent.util.Utils;
import com.manageengine.org.apache.logging.log4j.Level;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.List;

public final class JavaAgent
implements JavaAgentConstants {
    private static JavaAgent agent;
    private static JavaAgentHandler agentHandler;
    private Instrumentation inst;
    private static List<ClassFileTransformer> classTransformersList;
    public final JavaAgentConfig agentConfig;
    public static AgentLogger logger;
    private JavaAgentService agentService;
    private AgentUpgrader agentUpgrader = null;
    private ClassRetransformationEngine classRetransformEngine;
    private static boolean isAgentStarted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void premain(String options, Instrumentation inst) {
        if (agent != null) {
            return;
        }
        Log4j2PluginPreloadingClassTransformer log4j2PluginPreloadingClassTransformer = new Log4j2PluginPreloadingClassTransformer();
        inst.addTransformer(log4j2PluginPreloadingClassTransformer, false);
        try {
            agent = JavaAgent.createAgent(inst, options);
            logger.info("APM Insight agent initialized successfully.");
            agent.start();
            logger.info("APM Insight agent started successfully.");
            isAgentStarted = true;
        }
        catch (FatalException e) {
            if (logger != null) {
                logger.fatal("Agent is aborting initialization.", e);
            }
        }
        catch (Throwable th) {
            JavaAgentUtil.print("APM Insight: SEVERE: Could not create/start APM Insight agent! Exception: " + th.getMessage());
            if (logger != null) {
                logger.log(Level.FATAL, "Could not create/start APM Insight agent!!", th);
            }
            th.printStackTrace(JavaAgentUtil.getDefaultPrintStream());
        }
        finally {
            inst.removeTransformer(log4j2PluginPreloadingClassTransformer);
        }
    }

    public static void main(String[] args) {
        CommandLineArgsParser parser = new CommandLineArgsParser();
        parser.parse(args);
    }

    public static void agentmain(final String options, final Instrumentation inst) {
        WorkerThreadFactory.getInstance().newThread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("apminsight-Main-Starter");
                JavaAgent.premain(options, inst);
                if (isAgentStarted) {
                    try {
                        agent.classRetransformEngine.retransformAllClasses();
                    }
                    catch (Throwable th) {
                        logger.log(Level.WARN, "[AgentMain] Error occurred while retransforming. ", th);
                    }
                }
            }
        }).start();
    }

    public static JavaAgent getInstance() {
        return agent;
    }

    public static JavaAgent createAgent(Instrumentation inst, String options) throws FatalException {
        if (agent == null) {
            agent = new JavaAgent(inst, options);
        }
        return agent;
    }

    private JavaAgent(Instrumentation inst, String options) throws FatalException {
        this.inst = inst;
        this.agentConfig = new JavaAgentConfig(this, options);
        this.agentService = new JavaAgentService(this.agentConfig);
        agentHandler = new JavaAgentHandler(this.agentConfig, this.agentService.getTrackerService());
        this.classRetransformEngine = new ClassRetransformationEngine(inst);
    }

    public void start() {
        if (!Boolean.parseBoolean(System.getProperty("apminsight_noinstrument"))) {
            this.setupTransformers(this.inst);
            this.classRetransformEngine.retransformEscaped();
        }
        this.setupShutdownHooks();
        String threadName = "apminsight-services-starter";
        WorkerThreadFactory.getInstance().newThread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("apminsight-services-starter");
                logger.info("apminsight-services-starter started");
                JavaAgent.this.agentService.init();
                logger.info("apminsight-services-starter finished");
                if (JavaAgent.this.agentConfig.getLoggingConfig().getLoggerName() != LoggingConfig.CONSOLE_LOGGER.getLoggerName()) {
                    try {
                        JavaAgent.this.agentConfig.updateLogging(LoggingConfig.STARTUP_LOGGER.getLogFileName());
                    }
                    catch (FatalException | IOException e) {
                        logger.warn("Exception while updating log location - " + e);
                    }
                }
            }
        }).start();
    }

    public boolean shutdown() {
        logger.info("Agent shutting down.");
        this.agentConfig.agentVerified = false;
        this.removeAllTransformers();
        this.agentService.shutdown();
        for (MetricStore metricStore : MetricStoreController.getAllMetricStore()) {
            metricStore.cleanMetricStore();
        }
        SequenceTraceStore.emptySequenceTraceStore();
        SequenceHeaderQueue.clean();
        return false;
    }

    public static JavaAgentHandler getHandler() {
        return agentHandler;
    }

    public boolean deleteAgent(ContextInfo info, int inDays) {
        if (info.getInstanceState() != AgentState.MARKED_FOR_DELETE) {
            info.agentMarkedForDeleteTime = System.currentTimeMillis();
            return this.disableAgent(info, AgentState.MARKED_FOR_DELETE);
        }
        if (System.currentTimeMillis() - info.agentMarkedForDeleteTime >= (long)inDays * 86400000L) {
            if (!this.agentConfig.isContextMonitoringEnabled()) {
                this.shutdown();
            }
            info.setAgentState(AgentState.DELETED);
            this.agentConfig.writeAgentInfo(info);
            return false;
        }
        return true;
    }

    public boolean disableAgent(ContextInfo info) {
        return this.disableAgent(info, AgentState.UNMANAGED);
    }

    private boolean disableAgent(ContextInfo info, AgentState agentState) {
        if (this.agentConfig.agentVerified && info.getInstanceState() == agentState) {
            return true;
        }
        logger.info("Disabling monitoring for context '" + info.getContextName() + "'");
        info.setAgentState(agentState);
        this.cleanStore();
        this.agentConfig.writeAgentInfo(info);
        return true;
    }

    public void cleanStore() {
        for (MetricStore metricStore : MetricStoreController.getAllMetricStore()) {
            metricStore.cleanMetricStore();
        }
        SequenceTraceStore.emptySequenceTraceStore();
        SequenceHeaderQueue.clean();
    }

    public boolean enableAgent(ContextInfo info) {
        if (this.agentConfig.agentVerified && info.getInstanceState() == AgentState.MANAGED) {
            return true;
        }
        logger.info("Enabling the agent for context '" + info.getContextName() + "'");
        info.setAgentState(AgentState.MANAGED);
        this.agentConfig.writeAgentInfo(info);
        return true;
    }

    private void setupTransformers(Instrumentation inst) {
        ClassTransformer classTransformer = new ClassTransformer(agent);
        inst.addTransformer(classTransformer, true);
        logger.info("Javaagent setupTransformers completed with canRetransform as " + inst.isRetransformClassesSupported());
        classTransformersList.add(classTransformer);
    }

    private void removeAllTransformers() {
        for (ClassFileTransformer ct : classTransformersList) {
            this.inst.removeTransformer(ct);
        }
        logger.info(classTransformersList.size() + " transformer(s) successfully removed from instrumentation.");
    }

    private void setupShutdownHooks() {
        Runtime.getRuntime().addShutdownHook(new OnAppServerShutdownCleaner());
    }

    public JavaAgentService getAgentService() {
        return this.agentService;
    }

    public JavaAgentConfig getAgentConfig() {
        return this.agentConfig;
    }

    public ClassRetransformationEngine getClassRetransformEngine() {
        return this.classRetransformEngine;
    }

    public Instrumentation getInstrumentation() {
        return this.inst;
    }

    public void setAgentUpgrader(AgentUpgrader agentUpgrader) {
        this.agentUpgrader = agentUpgrader;
        logger.info("AgentUpgrader (" + this.agentUpgrader.toString() + ") was set to act when appserver shuts down.");
    }

    static {
        classTransformersList = new ArrayList<ClassFileTransformer>(1);
        isAgentStarted = false;
    }

    final class OnAppServerShutdownCleaner
    extends Thread {
        OnAppServerShutdownCleaner() {
            this.setName("apminsight-cleaner");
            this.setDaemon(false);
        }

        @Override
        public void run() {
            agent.shutdown();
            if (JavaAgent.this.agentUpgrader != null) {
                JavaAgent.this.agentUpgrader.execute();
            }
            try {
                long shutdownTime = System.currentTimeMillis();
                File file = new File(JavaAgent.this.agentConfig.getInstanceDir(), "apminsight.info");
                String contentToWrite = FileUtil.getInstance().readCharacterFile(file).replaceAll("agent.shutdown.time=\\d+", "agent.shutdown.time=" + shutdownTime);
                if (contentToWrite.contains("agent.shutdown.time")) {
                    FileUtil.getInstance().writeCharacterFile(file, contentToWrite);
                } else {
                    Utils.appendContentToFile(file, "agent.shutdown.time=" + shutdownTime);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

