/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.art;

import com.manageengine.apminsight.agent.art.ARTConstants;
import com.manageengine.apminsight.agent.art.ApplicationInfo;
import com.manageengine.apminsight.agent.art.SpanInfo;
import com.manageengine.apminsight.agent.art.TransactionInfo;
import com.manageengine.org.json.simple.JSONObject;
import com.manageengine.org.json.simple.JSONStreamAware;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ARTData
implements ARTConstants,
JSONStreamAware {
    private ApplicationInfo apmInfo;
    private TransactionInfo txnInfo;
    private List<SpanInfo> spansList;

    public ARTData(ApplicationInfo apmInfo) throws Exception {
        if (apmInfo == null) {
            throw new Exception("ApmInfo is null, stopping data construction");
        }
        this.apmInfo = apmInfo;
    }

    public void setTxnInfo(TransactionInfo txnInfo) {
        this.txnInfo = txnInfo;
    }

    public void setSpansList(List<SpanInfo> spansList) {
        this.spansList = spansList;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        HashMap<String, Map> finalData = new HashMap<String, Map>();
        finalData.put("apm", this.getFinalFormat());
        JSONObject.writeJSONString(finalData, out);
    }

    private Map getFinalFormat() {
        HashMap<String, Object> finalData = new HashMap<String, Object>();
        finalData.put("data", true);
        finalData.put("application_info", this.apmInfo);
        finalData.put("transaction_info", this.txnInfo);
        if (this.spansList != null) {
            HashMap<String, List<SpanInfo>> spansData = new HashMap<String, List<SpanInfo>>();
            spansData.put("span_info", this.spansList);
            finalData.put("method_info", spansData);
        }
        return finalData;
    }

    public String toString() {
        return this.getFinalFormat().toString();
    }
}

