/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.art;

import com.manageengine.apminsight.agent.art.ApplicationInfo;
import com.manageengine.apminsight.agent.context.ContextInfo;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.AbstractTracker;
import com.manageengine.apminsight.agent.trackers.CalleeAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.RootTracker;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.httpclient.IHttpClientTracker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RawTransactionData {
    private String traceid;
    private String parentSpanId;
    private String threadName;
    private boolean isAsyncRoot;
    private List<Tracker> spans;
    private long threadId;
    private long cputime;
    private long memoryAlloc;
    private long dtCallCount;
    private Map<String, List<String>> customParams;
    private RootTracker rootTracker;
    private ContextInfo contextInfo;

    public RawTransactionData(SequenceHeader sh) {
        this.rootTracker = sh.getRootTracker();
        this.isAsyncRoot = this.rootTracker instanceof CalleeAsyncRootTracker;
        this.traceid = this.rootTracker.getTraceID();
        this.parentSpanId = this.rootTracker.getParentSpanID();
        this.threadId = sh.getSequenceThreadId();
        this.threadName = sh.getSequenceThreadName();
        this.cputime = sh.getSeqCpuTimeInNanoSec();
        this.memoryAlloc = sh.getSeqMemoryAllocInBytes();
        this.customParams = sh.getCustomParams();
        this.contextInfo = ContextInfoManager.getInstance().getContextInfoIfPresent(sh.getContextName());
        this.spans = new ArrayList<Tracker>();
        this.constructSpans((AbstractTracker)((Object)this.rootTracker));
    }

    private void constructSpans(AbstractTracker tracker) {
        this.addSpan(tracker);
        String parentSpanId = tracker.getSpanID();
        tracker = tracker.child;
        while (tracker != null) {
            tracker.setParentSpanID(parentSpanId);
            this.constructSpans(tracker);
            tracker = tracker.sibling;
        }
    }

    public void addSpan(Tracker tracker) {
        this.spans.add(tracker);
        if (tracker instanceof IHttpClientTracker && ((IHttpClientTracker)((Object)tracker)).isDTCall()) {
            ++this.dtCallCount;
        }
    }

    public String getTraceid() {
        return this.traceid;
    }

    public void setTraceid(String traceid) {
        this.traceid = traceid;
    }

    public String getParentSpanId() {
        return this.parentSpanId;
    }

    public void setParentSpanId(String parentSpanId) {
        this.parentSpanId = parentSpanId;
    }

    public boolean isAsyncRoot() {
        return this.isAsyncRoot;
    }

    public void setAsyncRoot(boolean isAsyncRoot) {
        this.isAsyncRoot = isAsyncRoot;
    }

    public List<Tracker> getSpans() {
        return this.spans;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getCputime() {
        return this.cputime;
    }

    public void setCputime(long cputime) {
        this.cputime = cputime;
    }

    public long getMemoryAlloc() {
        return this.memoryAlloc;
    }

    public void setMemoryAlloc(long memoryAlloc) {
        this.memoryAlloc = memoryAlloc;
    }

    public Map<String, List<String>> getCustomParams() {
        return this.customParams;
    }

    public void setCustomParams(Map<String, List<String>> customParams) {
        this.customParams = customParams;
    }

    public RootTracker getRootTracker() {
        return this.rootTracker;
    }

    public void setRootTracker(RootTracker rootTracker) {
        this.rootTracker = rootTracker;
    }

    public long getDtCallCount() {
        return this.dtCallCount;
    }

    public void setContextInfo(ContextInfo contextInfo) {
        this.contextInfo = contextInfo;
    }

    public ContextInfo getContextInfo() {
        return this.contextInfo;
    }

    public ApplicationInfo getAppInfo() {
        return this.contextInfo.getAppInfo();
    }

    public boolean isContextRegistered() {
        return this.contextInfo.isRegistered();
    }
}

