/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.art;

import com.manageengine.apminsight.agent.art.ARTConstants;
import com.manageengine.apminsight.agent.art.ExceptionInfo;
import com.manageengine.apminsight.agent.components.Component;
import com.manageengine.apminsight.agent.tracing.StackTrace;
import com.manageengine.apminsight.agent.trackers.CalleeAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.db.DatabaseTracker;
import com.manageengine.apminsight.agent.trackers.external.IExternalTracker;
import com.manageengine.apminsight.agent.trackers.httpclient.IHttpClientTracker;
import com.manageengine.apminsight.agent.util.InetAddressUtil;
import com.manageengine.org.json.simple.JSONObject;
import com.manageengine.org.json.simple.JSONStreamAware;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SpanInfo
implements ARTConstants,
JSONStreamAware {
    private String spanId;
    private String parentSpanId;
    private Boolean isAsyncRoot;
    private long starttime;
    private long endtime;
    private String signature;
    private String componentName;
    private int isError;
    private StackTrace stacktrace;
    private List<ExceptionInfo> exceptionInfo;
    private int isExternal;
    private String externalHost;
    private int externalPort;
    private Map dtData;
    private String dbQuery = "";
    private int methodOrder;

    public SpanInfo(Tracker tracker, int methodOrder) {
        this.spanId = tracker.getSpanID();
        this.parentSpanId = tracker.getParentSpanID();
        this.isAsyncRoot = tracker instanceof CalleeAsyncRootTracker;
        this.starttime = tracker.getStartTime();
        this.endtime = this.starttime + (long)tracker.getDuration();
        this.signature = tracker.getTrackerSignature();
        this.methodOrder = methodOrder;
        Component component = tracker.getPointcutProperties().getComponent();
        this.componentName = component.toString();
        int n = this.isExternal = component.isExternal() ? 1 : 0;
        if (this.isExternal == 1) {
            if (tracker instanceof IExternalTracker) {
                String address = ((IExternalTracker)((Object)tracker)).getServerAddress();
                address = InetAddressUtil.standardizeServerAddress(address);
                this.externalPort = InetAddressUtil.getPort(address);
                this.externalHost = InetAddressUtil.getHostName(address);
            }
            if (tracker instanceof DatabaseTracker) {
                DatabaseTracker dbTracker = (DatabaseTracker)((Object)tracker);
                for (String query : dbTracker.getQueries()) {
                    this.dbQuery = this.dbQuery + query + ";";
                }
                if (dbTracker.getStackTraceElement() != null) {
                    this.stacktrace = new StackTrace(dbTracker.getStackTraceElement());
                }
            } else if (tracker instanceof IHttpClientTracker) {
                this.dtData = ((IHttpClientTracker)((Object)tracker)).getDTdata();
            }
        }
        if (tracker.getErrorCause() != null) {
            this.isError = 1;
            this.exceptionInfo = new ArrayList<ExceptionInfo>();
            this.exceptionInfo.add(new ExceptionInfo(this.endtime, tracker.getErrorCause()));
            this.stacktrace = new StackTrace(tracker.getErrorCause().getStackTrace());
        } else {
            this.isError = 0;
        }
    }

    private Map getDataInMap() {
        LinkedHashMap<String, Object> mapData = new LinkedHashMap<String, Object>();
        mapData.put("si", this.spanId);
        mapData.put("psi", this.parentSpanId);
        mapData.put("ar", this.isAsyncRoot);
        mapData.put("st", this.starttime);
        mapData.put("et", this.endtime);
        mapData.put("fn", this.signature);
        mapData.put("cn", this.componentName);
        mapData.put("pr", 1);
        mapData.put("mo", this.methodOrder);
        mapData.put("ex", this.isExternal);
        if (this.externalPort > 0) {
            mapData.put("pn", this.externalPort);
        }
        mapData.put("hn", this.externalHost);
        mapData.put("dt", this.dtData);
        mapData.put("ie", this.isError);
        mapData.put("mst", this.stacktrace);
        mapData.put("ei", this.exceptionInfo);
        mapData.put("qs", this.dbQuery);
        mapData.entrySet().removeIf(entry -> entry.getValue() == null);
        return mapData;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONObject.writeJSONString(this.getDataInMap(), out);
    }
}

