/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.art;

import com.manageengine.apminsight.agent.art.ARTConstants;
import com.manageengine.apminsight.agent.art.RawTransactionData;
import com.manageengine.apminsight.agent.sequence.SequenceType;
import com.manageengine.apminsight.agent.trackers.RootTracker;
import com.manageengine.apminsight.agent.trackers.WebSeqRootTracker;
import com.manageengine.org.json.simple.JSONObject;
import com.manageengine.org.json.simple.JSONStreamAware;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TransactionInfo
implements ARTConstants,
JSONStreamAware {
    private int is_async;
    private int transaction_type;
    private int dt_count;
    private int httpcode;
    private long bytes_in;
    private long bytes_out;
    private long thread_id;
    private long s_time;
    private long e_time;
    private long cputime;
    private long memalloc;
    private String http_host;
    private String t_name;
    private String http_method_name;
    private String http_query_str;
    private String trace_id;
    private String session_id;
    private String thread_name;
    private Map<String, List<String>> custom_params;
    private Map<String, List<String>> http_headers;
    private Map<String, List<String>> http_input_params;

    public TransactionInfo(RawTransactionData rawData) {
        RootTracker rootTracker = rawData.getRootTracker();
        this.is_async = rawData.isAsyncRoot() ? 1 : 0;
        this.transaction_type = rootTracker.getSequenceType() == SequenceType.WEB_HTTP ? 1 : 0;
        this.trace_id = rawData.getTraceid();
        this.t_name = rootTracker.getUnnormalizedSeqName();
        this.s_time = rootTracker.getStartTime();
        this.e_time = this.s_time + (long)rootTracker.getDuration();
        if (this.transaction_type == 1) {
            WebSeqRootTracker tracker = (WebSeqRootTracker)rootTracker;
            this.http_host = tracker.getHttpHost();
            this.httpcode = tracker.getHttpRespCode();
            this.bytes_in = tracker.getHttpRequestSize();
            this.bytes_out = tracker.getHttpBytesWritten();
            this.http_method_name = tracker.getHttpMethod();
            this.http_headers = tracker.getHttpHeaders();
            this.http_input_params = tracker.getHttpParams();
        }
        this.thread_name = rawData.getThreadName();
        this.thread_id = rawData.getThreadId();
        this.cputime = TimeUnit.NANOSECONDS.toMillis(rawData.getCputime());
        this.memalloc = rawData.getMemoryAlloc() / 1024L;
        this.custom_params = rawData.getCustomParams();
        this.dt_count = (int)rawData.getDtCallCount();
    }

    private Map<String, Object> getDataInMap() {
        LinkedHashMap<String, Object> mapData = new LinkedHashMap<String, Object>();
        mapData.put("async", this.is_async);
        mapData.put("transaction_type", this.transaction_type);
        mapData.put("trace_id", this.trace_id);
        mapData.put("t_name", this.t_name);
        mapData.put("http_method_name", this.http_method_name);
        mapData.put("http_query_str", this.http_query_str);
        mapData.put("http_host", this.http_host);
        mapData.put("http_headers", this.http_headers);
        mapData.put("http_input_parms", this.http_input_params);
        mapData.put("session_id", this.session_id);
        if (this.bytes_in >= 0L) {
            mapData.put("bytes_in", this.bytes_in);
        }
        if (this.bytes_out >= 0L) {
            mapData.put("bytes_out", this.bytes_out);
        }
        if (this.httpcode > 0) {
            mapData.put("httpcode", this.httpcode);
        }
        mapData.put("s_time", this.s_time);
        mapData.put("e_time", this.e_time);
        if (this.cputime > 0L) {
            mapData.put("cputime", this.cputime);
        }
        if (this.memalloc > 0L) {
            mapData.put("memalloc", this.memalloc);
        }
        mapData.put("thread_id", this.thread_id);
        mapData.put("thread_name", this.thread_name);
        if (this.dt_count > 0) {
            mapData.put("dt_count", this.dt_count);
        }
        mapData.put("custom_params", this.custom_params);
        mapData.entrySet().removeIf(entry -> entry.getValue() == null);
        return mapData;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONObject.writeJSONString(this.getDataInMap(), out);
    }
}

