/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.art.dispatcher;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.art.ARTConstants;
import com.manageengine.apminsight.agent.art.ARTData;
import com.manageengine.apminsight.agent.art.store.ARTStore;
import com.manageengine.apminsight.agent.context.ContextInfo;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.dataexporter.DataExporterService;
import com.manageengine.apminsight.agent.service.AgentServiceConstants;
import com.manageengine.apminsight.agent.thread.WorkerThreadFactory;
import java.util.List;

public class ARTDataDispatcher
implements Runnable,
ARTConstants,
AgentServiceConstants {
    @Override
    public void run() {
        try {
            if (!JavaAgent.getInstance().getAgentConfig().isARTEnabled()) {
                return;
            }
            JavaAgent.logger.debug("ART data dispatcher started for all contexts.");
            for (ContextInfo contextInfo : ContextInfoManager.getInstance().getAllContexts()) {
                List<ARTData> data = ARTStore.getInstance().getDataToDispatch(contextInfo);
                if (data.isEmpty()) continue;
                if (JavaAgent.getInstance().agentConfig.isDataExporterEnabled()) {
                    this.sendDataViaExporter(contextInfo, data);
                } else {
                    JavaAgent.getInstance().getAgentService().sendDataToServer(contextInfo, "span_data", data);
                }
                JavaAgent.logger.info("{} ART data is dispatched for context {}.", data.size(), contextInfo.getContextName());
            }
            JavaAgent.logger.info("ART data dispatched for all contexts.");
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Unable to dispatch ART data. Exception: ", th);
        }
    }

    private void sendDataViaExporter(ContextInfo contextInfo, Object data) {
        DataExporterService.getInstance().sendData(contextInfo, "data", data);
    }

    public static void emergencyDispatch(ContextInfo contextInfo) {
        JavaAgent.logger.info("Initiating emergency dispatch of ART data");
        Thread thread = WorkerThreadFactory.getInstance().newThread(new ARTDataDispatcher());
        thread.start();
    }
}

