/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.art.processor;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.art.ARTConstants;
import com.manageengine.apminsight.agent.art.ARTData;
import com.manageengine.apminsight.agent.art.RawTransactionData;
import com.manageengine.apminsight.agent.art.SpanInfo;
import com.manageengine.apminsight.agent.art.TransactionInfo;
import com.manageengine.apminsight.agent.art.processor.ARTQueue;
import com.manageengine.apminsight.agent.art.store.ARTStore;
import com.manageengine.apminsight.agent.context.ContextInfo;
import com.manageengine.apminsight.agent.thread.WorkerThreadFactory;
import com.manageengine.apminsight.agent.trackers.Tracker;
import java.util.ArrayList;
import java.util.List;

public class ARTDataProcessor
implements ARTConstants,
Runnable {
    private static boolean isRunning;
    private static final short TAKE_A_BREAK = 100;
    private ARTStore artStore = ARTStore.getInstance();

    public ARTDataProcessor() {
        JavaAgent.logger.info("ART data processor initialized");
    }

    @Override
    public void run() {
        int count = 0;
        isRunning = true;
        JavaAgent.logger.info("ART data processor is running");
        while (isRunning) {
            try {
                RawTransactionData rawData = ARTQueue.getInstance().pop();
                this.doProcessing(rawData);
                if ((count = (int)((short)(count + 1))) != 100) continue;
                Thread.sleep(250L);
                count = 0;
            }
            catch (InterruptedException e) {
                JavaAgent.logger.warn("[ARTDataProcessor] interrupted, initiating next pickup", e);
            }
        }
        JavaAgent.logger.info("ART Data Processor is finished, quitting now");
    }

    private void doProcessing(RawTransactionData rawData) {
        try {
            if (!rawData.isContextRegistered()) {
                this.initiateRegistration(rawData.getContextInfo());
                return;
            }
            ARTConstants.SpanType spanType = JavaAgent.getInstance().agentConfig.getARTCaptureSpanType();
            ARTData artData = new ARTData(rawData.getAppInfo());
            artData.setTxnInfo(new TransactionInfo(rawData));
            if (spanType != ARTConstants.SpanType.ROOT) {
                List<SpanInfo> spans = this.generateSpans(rawData.getSpans(), spanType);
                artData.setSpansList(spans);
            }
            this.artStore.push(rawData.getContextInfo(), artData);
        }
        catch (IllegalStateException ise) {
            JavaAgent.logger.warn("Found mismatch in trackers order, aborting processing of {} Exception: {}", rawData.getRootTracker().getSequenceNameSpace(), ise.getMessage());
        }
        catch (Exception e) {
            JavaAgent.logger.warn("[ART processor] Unable to process ART Data ", e);
        }
    }

    private void initiateRegistration(ContextInfo contextInfo) {
        WorkerThreadFactory.getInstance().newThread(new ContextRegistrar(contextInfo), "context-registrar");
    }

    private List<SpanInfo> generateSpans(List<Tracker> trackers, ARTConstants.SpanType spanType) throws IllegalStateException {
        ArrayList<SpanInfo> spans = new ArrayList<SpanInfo>();
        int spansCount = 0;
        int trackersCount = trackers.size();
        for (Tracker tracker : trackers) {
            if (spanType != ARTConstants.SpanType.ALL && (spanType != ARTConstants.SpanType.EXT || !tracker.isExternalTracker())) continue;
            SpanInfo span = new SpanInfo(tracker, spansCount++);
            spans.add(span);
        }
        if (spansCount > trackersCount) {
            throw new IllegalStateException("Tracker order is mixed up, current count value: " + spansCount);
        }
        return spans;
    }

    public void shutdown() {
        isRunning = false;
        this.artStore.cleanup();
        JavaAgent.logger.info("ARTDataProcessor is shutdown.");
    }

    private class ContextRegistrar
    implements Runnable {
        private ContextInfo contextInfo;

        public ContextRegistrar(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
        }

        @Override
        public void run() {
            try {
                JavaAgent.getInstance().getAgentService().connect(this.contextInfo);
            }
            catch (Throwable th) {
                JavaAgent.logger.warn("'" + this.contextInfo.getContextName() + "' Context registration failed. Exception: " + th.getMessage());
            }
        }
    }
}

