/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.art.processor;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.art.RawTransactionData;
import java.util.concurrent.ArrayBlockingQueue;

public class ARTQueue {
    private ArrayBlockingQueue<RawTransactionData> q;
    private static ARTQueue artQueue;

    private ARTQueue() {
        int size = JavaAgent.getInstance().agentConfig.getTrackerStoreSize();
        this.q = new ArrayBlockingQueue(size);
    }

    public static ARTQueue getInstance() {
        if (artQueue == null) {
            artQueue = new ARTQueue();
        }
        return artQueue;
    }

    public boolean push(RawTransactionData data) {
        try {
            return this.q.add(data);
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("ARTQueue is full, dropping txn. Current queue size: " + this.q.size());
            return false;
        }
    }

    public RawTransactionData pop() throws InterruptedException {
        return this.q.take();
    }

    public void shutdown() {
        this.q.clear();
        JavaAgent.logger.info("ARTQueue elements cleared & shutdown");
    }
}

