/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.art.store;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.art.ARTData;
import com.manageengine.apminsight.agent.art.dispatcher.ARTDataDispatcher;
import com.manageengine.apminsight.agent.context.ContextInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ARTStore {
    private static ARTStore artStore;
    private Map<ContextInfo, List<ARTData>> artDataMap = new HashMap<ContextInfo, List<ARTData>>();
    private static final int LIMIT = 250;

    private ARTStore() {
    }

    public static ARTStore getInstance() {
        if (artStore == null) {
            artStore = new ARTStore();
            JavaAgent.logger.info("ART Store initialised with size: 250");
        }
        return artStore;
    }

    public void push(ContextInfo context, ARTData artData) {
        List<ARTData> list = this.artDataMap.get(context);
        if (list == null) {
            list = new ArrayList<ARTData>();
            this.artDataMap.put(context, list);
        }
        list.add(artData);
        if (list.size() == 250) {
            ARTDataDispatcher.emergencyDispatch(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ARTData> getDataToDispatch(ContextInfo contextInfo) {
        ArrayList<ARTData> duplicate;
        List<ARTData> data = this.artDataMap.get(contextInfo);
        if (data == null) {
            return Collections.emptyList();
        }
        List<ARTData> list = data;
        synchronized (list) {
            duplicate = new ArrayList<ARTData>(data);
            data.clear();
        }
        return duplicate;
    }

    public void cleanup() {
        this.artDataMap.clear();
        JavaAgent.logger.info("ART store is cleaned up");
    }
}

