/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.autoupgrade;

import com.manageengine.apminsight.agent.autoupgrade.AgentUpgraderService;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.logging.AgentLogger;
import com.manageengine.apminsight.agent.service.AgentServiceConstants;
import com.manageengine.apminsight.agent.util.FileUtil;
import com.manageengine.org.apache.logging.log4j.Level;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class AgentUpgrader
implements AgentServiceConstants {
    private File apminsightHome;
    private File updateTempDir;
    private File agentLocation;
    private AgentLogger logger;
    private static final String BACKUP_DIR_PREFIX = "apminsight_javaagent_";
    public static final String AGENT_FILE_NAME = "apminsight-javaagent.jar";
    public static final String AGENT_README_FILE_NAME = "readme.txt";
    public static final String AGENT_API_JAR_FILE_NAME = "apminsight-javaagent-api.jar";

    public AgentUpgrader(File apminsightHome, File updateTempDir, File agentLocation, AgentLogger logger) {
        this.apminsightHome = apminsightHome;
        this.updateTempDir = updateTempDir;
        this.agentLocation = agentLocation;
        this.logger = logger;
    }

    public void execute() {
        this.logger.info("AgentUpgrader started.");
        File backupDir = null;
        try {
            backupDir = this.createBackupDir();
            this.logger.info("javaagent upgrade - backup directory created successfully. " + backupDir.getAbsolutePath());
        }
        catch (Exception e) {
            String msg = "unable to create the backup directory.";
            this.logger.log(Level.FATAL, msg, e);
            AgentUpgraderService.intimateErrToCollector(msg);
            return;
        }
        try {
            this.packObsoleteFilesTo(backupDir);
            this.logger.info("obsolete files backup done successfully. ");
        }
        catch (Exception e) {
            this.logger.log(Level.FATAL, "unable to backup obsolete files.", e);
            try {
                this.restoreObsoleteFilesFrom(backupDir);
                this.logger.info("obsolete files restored successfully.");
            }
            catch (Exception ex) {
                this.logger.log(Level.FATAL, "unable to restore obsolete files.", ex);
            }
            AgentUpgraderService.intimateErrToCollector("unable to backup obsolete files.");
            return;
        }
        try {
            this.installNewFiles();
            this.logger.info("new agent files installed successfully.");
        }
        catch (Exception e) {
            this.logger.log(Level.FATAL, "Unable to install the new agent files.", e);
            try {
                this.restoreObsoleteFilesFrom(backupDir);
                this.logger.info("obsolete files restored successfully.");
            }
            catch (Exception ex) {
                this.logger.log(Level.FATAL, "unable to restore obsolete files.", ex);
            }
            AgentUpgraderService.intimateErrToCollector("unable to install new agent files.");
            return;
        }
        try {
            FileUtil.cleanDirectory(this.updateTempDir);
            this.updateTempDir.delete();
            this.logger.info("javaagent update temporary directory cleaned. " + this.updateTempDir.getAbsolutePath());
        }
        catch (Exception e) {
            this.logger.warn("unable to clean the javaagent update temporary directory. " + this.updateTempDir.getAbsolutePath());
        }
        this.logger.info("Agent successfully upgraded to the latest version from version: " + JavaAgentConfig.getAgentFullVersion());
    }

    private File createBackupDir() throws IOException {
        String currAgentVersion = JavaAgentConfig.getAgentFullVersion().replace('.', '_');
        File backupDir = new File(this.apminsightHome, BACKUP_DIR_PREFIX + currAgentVersion);
        backupDir.mkdir();
        return backupDir;
    }

    private void packObsoleteFilesTo(File destDir) throws Exception {
        AgentUpgrader.moveFiles(this.apminsightHome, this.agentLocation, destDir);
    }

    private void restoreObsoleteFilesFrom(File backupDir) throws Exception {
        AgentUpgrader.moveFiles(backupDir, backupDir, this.apminsightHome);
    }

    private static void moveFiles(File confSourceDir, File agentSourceDir, File toDir) throws Exception {
        File agentFile;
        File agentApiJarFile;
        File readMeFile;
        File confFile = new File(confSourceDir, "apminsight.conf");
        if (confFile.exists()) {
            FileUtil.fileCopy(confFile, new File(toDir, "apminsight.conf"), true);
            confFile.delete();
        }
        if ((readMeFile = new File(confSourceDir, AGENT_README_FILE_NAME)).exists()) {
            FileUtil.fileCopy(readMeFile, new File(toDir, AGENT_README_FILE_NAME), true);
            readMeFile.delete();
        }
        if ((agentApiJarFile = new File(confSourceDir, AGENT_API_JAR_FILE_NAME)).exists()) {
            FileUtil.fileCopy(agentApiJarFile, new File(toDir, AGENT_API_JAR_FILE_NAME), true);
            agentApiJarFile.delete();
        }
        if ((agentFile = new File(agentSourceDir, AGENT_FILE_NAME)).exists()) {
            FileUtil.fileCopy(agentFile, new File(toDir, AGENT_FILE_NAME), true);
            agentFile.delete();
        }
    }

    private void installNewFiles() throws IOException {
        File[] files;
        for (File file : files = this.updateTempDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File fileDir, String fileName) {
                return !fileName.endsWith(AgentUpgrader.AGENT_FILE_NAME);
            }
        })) {
            FileUtil.fileCopy(file, new File(this.apminsightHome, file.getName()), true);
        }
        FileUtil.fileCopy(new File(this.updateTempDir, AGENT_FILE_NAME), new File(this.agentLocation, AGENT_FILE_NAME), true);
    }
}

