/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.communication.http;

import com.manageengine.apminsight.agent.communication.ProxyConfig;
import com.manageengine.apminsight.agent.communication.http.CustomSSLSocketFactory;
import com.manageengine.apminsight.agent.communication.http.HttpConfig;
import com.manageengine.org.apache.hc.client5.http.auth.AuthScope;
import com.manageengine.org.apache.hc.client5.http.auth.NTCredentials;
import com.manageengine.org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import com.manageengine.org.apache.hc.client5.http.config.RequestConfig;
import com.manageengine.org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import com.manageengine.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.manageengine.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import com.manageengine.org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import com.manageengine.org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import com.manageengine.org.apache.hc.core5.http.HttpHost;
import com.manageengine.org.apache.hc.core5.util.Timeout;
import javax.net.ssl.HostnameVerifier;

public class HttpClientBuilder {
    private HttpConfig httpConfig;
    private ProxyConfig proxyConfig;

    public HttpClientBuilder setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        return this;
    }

    public HttpClientBuilder setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
        return this;
    }

    public CloseableHttpClient build() {
        com.manageengine.org.apache.hc.client5.http.impl.classic.HttpClientBuilder httpClientBuilder = com.manageengine.org.apache.hc.client5.http.impl.classic.HttpClientBuilder.create();
        if (this.httpConfig != null) {
            httpClientBuilder.setDefaultRequestConfig(this.buildCustomRequestConfig());
        }
        httpClientBuilder.setConnectionManager(PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory(new SSLConnectionSocketFactory(new CustomSSLSocketFactory(), new String[]{"TLSv1.2"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build());
        if (this.proxyConfig != null) {
            this.configureProxy(this.proxyConfig, httpClientBuilder);
        }
        httpClientBuilder.disableDefaultUserAgent();
        return httpClientBuilder.build();
    }

    private void configureProxy(ProxyConfig config, com.manageengine.org.apache.hc.client5.http.impl.classic.HttpClientBuilder httpClientBuilder) {
        BasicCredentialsProvider credentialsStore = new BasicCredentialsProvider();
        credentialsStore.setCredentials(new AuthScope(null, config.getProxyHost(), Integer.parseInt(config.getProxyPort()), null, "NTLM"), new NTCredentials(config.getProxyUsername(), config.getProxyPassword().toCharArray(), "", ""));
        credentialsStore.setCredentials(new AuthScope(config.getProxyHost(), Integer.parseInt(config.getProxyPort())), new UsernamePasswordCredentials(config.getProxyUsername(), config.getProxyPassword().toCharArray()));
        HttpHost proxyHost = new HttpHost(config.getProxyHost(), Integer.parseInt(config.getProxyPort()));
        httpClientBuilder.setProxy(proxyHost);
        httpClientBuilder.setDefaultCredentialsProvider(credentialsStore);
    }

    private RequestConfig buildCustomRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(Timeout.ofSeconds(this.httpConfig.getConnectTimeout())).setResponseTimeout(Timeout.ofSeconds(this.httpConfig.getSocketTimeout())).setExpectContinueEnabled(true).build();
    }
}

