/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.components;

import com.manageengine.apminsight.agent.JavaAgent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Component {
    private final String name;
    private final boolean isExternal;
    private static final Map<String, Component> ALL = new HashMap<String, Component>(8, 0.75f);
    private static final Object LOCK = new Object();
    private static int size = 0;
    public static final Component APP_CODE = new Component("APP CODE");
    public static final Component SUMMARY = new Component("SUMMARY");
    public static final Component MYSQL = new Component("MYSQL", true);
    public static final Component MSSQL = new Component("MSSQL", true);
    public static final Component ORACLE = new Component("ORACLE", true);
    public static final Component SYBASE = new Component("SYBASE", true);
    public static final Component IBMDB2 = new Component("IBMDB2", true);
    public static final Component PGSQL = new Component("PGSQL", true);
    public static final Component YUGABYTE = new Component("YUGABYTE", true);
    public static final Component INFORMIX = new Component("INFORMIX", true);
    public static final Component JDBC = new Component("JDBC", true);
    public static final Component R2DBC = new Component("R2DBC", true);
    public static final Component CASSANDRA = new Component("CASSANDRA", true);
    public static final Component MONGODB = new Component("MONGODB", true);
    public static final Component ELASTIC_SEARCH = new Component("ELASTIC SEARCH", true);
    public static final Component MEMCACHED = new Component("MEMCACHED", true);
    public static final Component REDIS = new Component("REDIS", true);
    public static final Component KAFKA = new Component("KAFKA", true);
    public static final Component ACTIVEMQ = new Component("ACTIVEMQ", true);
    public static final Component RABBITMQ = new Component("RABBITMQ", true);
    public static final Component HTTP_CALL = new Component("HTTP CALL", true);
    public static final Component GRPC = new Component("GRPC", true);

    private Component(String name) {
        this(name, false);
    }

    private Component(String name, boolean isExternal) {
        this.name = name.toUpperCase();
        this.isExternal = isExternal;
        ALL.put(this.name, this);
        ++size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component get(String componentName) {
        if ((componentName = componentName.toUpperCase()).equals("DEFAULT")) {
            return APP_CODE;
        }
        Component c = ALL.get(componentName);
        if (c == null) {
            Object object = LOCK;
            synchronized (object) {
                c = ALL.get(componentName);
                if (c == null) {
                    c = new Component(componentName);
                    JavaAgent.logger.debug("New custom component created. " + componentName);
                }
            }
        }
        return c;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public static Collection<Component> list() {
        return ALL.values();
    }

    public static List<String> listAsString() {
        ArrayList<String> asString = new ArrayList<String>(size);
        for (Component c : ALL.values()) {
            asString.add(c.name);
        }
        return asString;
    }

    public static int size() {
        return size;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Component) {
            return ((Component)o).name.equals(this.name);
        }
        return false;
    }
}

