/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.config;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.JavaAgentConstants;
import com.manageengine.apminsight.agent.config.AgentDebugModeConfig;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.context.ContextInfo;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.context.ContextNameChanger;
import com.manageengine.apminsight.agent.instrumentation.InterceptorDefinitionFactory;
import com.manageengine.apminsight.agent.jmx.CustomJmxExtension;
import com.manageengine.apminsight.agent.logging.AgentLogger;
import com.manageengine.apminsight.agent.sequence.SequenceNameChanger;
import com.manageengine.apminsight.agent.util.Utils;
import com.manageengine.org.apache.logging.log4j.Level;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class AgentConfigListener
implements JavaAgentConstants {
    private JavaAgentConfig javaAgentConfig;
    private AgentLogger logger;
    private Map<String, Long> confFiles = new HashMap<String, Long>(2);
    private String[] confFileNames = new String[]{"apminsight.conf", "instrumentation.conf", "transaction_merge_patterns.conf", "debug_mode.conf", "key_transactions.conf", "context_naming_patterns.conf", "jmx_extensions.conf"};

    public AgentConfigListener(JavaAgentConfig javaAgentConfig, AgentLogger logger) throws Throwable {
        this.javaAgentConfig = javaAgentConfig;
        this.logger = logger == null ? javaAgentConfig.logger : logger;
        this.updateLastModifiedTime();
        this.logger.info("Configuration file listener initialized successfully.");
    }

    public void execute() throws Throwable {
        for (String confFileName : this.confFileNames) {
            Map<String, Object> agentConfigAsMap;
            File confFile = new File(this.javaAgentConfig.getInstanceDir(), confFileName);
            if (!this.javaAgentConfig.agentVerified && confFile.getName().equals("apminsight.conf")) {
                this.loadConfigValues(confFile);
            }
            if (!confFile.exists() || this.confFiles.containsKey(confFileName) && confFile.lastModified() <= this.confFiles.get(confFileName)) continue;
            this.logger.log(Level.DEBUG, "{} last modified at {} ms", confFile.getName(), confFile.lastModified());
            this.loadConfigValues(confFile);
            if (this.javaAgentConfig.agentVerified && "apminsight.conf".equals(confFileName) && (agentConfigAsMap = this.javaAgentConfig.getAgentCollectorSyncConfValues()) != null) {
                HashMap<String, Map<String, Object>> agentConfig = new HashMap<String, Map<String, Object>>();
                agentConfig.put("agent_specific_info", agentConfigAsMap);
                JavaAgent.getInstance().getAgentService().sendDataToServer(ContextInfoManager.getInstance().getDefaultContextInfo(), "agent_config_update", agentConfig);
                this.logger.info("Updated agent config sent to server.");
                this.javaAgentConfig.removeNonNativeConfigs();
            }
            this.confFiles.put(confFileName, confFile.lastModified());
        }
        this.pushRumAppKeysToCollector();
    }

    private void pushRumAppKeysToCollector() {
        for (ContextInfo contextInfo : ContextInfoManager.getInstance().getAllContexts()) {
            List<String> keys;
            if (!contextInfo.isActive() || (keys = contextInfo.getRumAppKeys()).isEmpty()) continue;
            Map<String, List<String>> payload = Collections.singletonMap("rum.app.keys", keys);
            try {
                JavaAgent.getInstance().getAgentService().sendDataToServer(contextInfo, "agent_config_update", payload);
                contextInfo.markPushedRumAppKeys(keys);
            }
            catch (Exception e) {
                JavaAgent.logger.error("Error occurred pushing RUM appkeys to collector", e);
            }
        }
    }

    private void loadConfigValues(File confFile) throws Throwable {
        Properties agentConfigProp = null;
        agentConfigProp = Utils.getContentAsProps(confFile);
        if (!agentConfigProp.isEmpty() && confFile.getName().equals("apminsight.conf")) {
            this.javaAgentConfig.initAgentRuntimeConfig(agentConfigProp, null);
            if (this.javaAgentConfig.agentVerified) {
                this.javaAgentConfig.updateAgentUserConfig(agentConfigProp);
                this.javaAgentConfig.updateAdditionalAgentConfig(agentConfigProp);
                this.javaAgentConfig.reinit();
                ContextInfoManager.getInstance().updateAllContextsConfig(agentConfigProp);
            }
        } else if (!agentConfigProp.isEmpty() && confFile.getName().equals("instrumentation.conf")) {
            InterceptorDefinitionFactory.getInstance().sanitizeInterceptorDefinitions(agentConfigProp, true);
        } else if (confFile.getName().equals("transaction_merge_patterns.conf")) {
            SequenceNameChanger.initialize(confFile);
        } else if (confFile.getName().equals("jmx_extensions.conf")) {
            CustomJmxExtension.getInstance().initialize(confFile);
        } else if (this.javaAgentConfig.isContextMonitoringEnabled() && confFile.getName().equals("context_naming_patterns.conf")) {
            ContextNameChanger.initialize(agentConfigProp);
        } else if (!agentConfigProp.isEmpty() && confFile.getName().equals("debug_mode.conf")) {
            AgentDebugModeConfig.getInstance().reinitialize();
            String mode = agentConfigProp.getProperty("agent.debug.mode");
            if (!this.javaAgentConfig.isDebugModeEnabled() && Boolean.parseBoolean(mode)) {
                this.logger.log(Level.INFO, "Enabling DEBUG mode...");
                this.javaAgentConfig.enableDebugMode();
            }
        } else if (confFile.getName().equals("key_transactions.conf")) {
            AgentDebugModeConfig.initializeSequenceFilter(confFile);
        }
        if (confFile.exists()) {
            this.logger.log(Level.INFO, "Modified configuration values in file {} updated successfully.", (Object)confFile.getName());
        }
    }

    public long getLastModifiedTime() {
        return this.confFiles.get("apminsight.conf");
    }

    public void updateLastModifiedTime() {
        for (String confFileName : this.confFileNames) {
            File confFile = new File(this.javaAgentConfig.getInstanceDir(), confFileName);
            if (!confFile.exists()) continue;
            this.confFiles.put(confFileName, confFile.lastModified());
        }
    }
}

