/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.config;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.JavaAgentConstants;
import com.manageengine.apminsight.agent.util.JavaAgentUtil;
import com.manageengine.apminsight.agent.util.Utils;
import com.manageengine.org.apache.logging.log4j.Level;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Properties;
import java.util.regex.Pattern;

public class AgentDebugModeConfig
implements JavaAgentConstants {
    private static AgentDebugModeConfig debugModeConfig = null;
    private Properties debugConfigProps;
    private int debugModeDuration;
    private static Pattern regex;

    private AgentDebugModeConfig() {
        this.initialize();
    }

    public static AgentDebugModeConfig getInstance() {
        if (debugModeConfig == null) {
            debugModeConfig = new AgentDebugModeConfig();
        }
        return debugModeConfig;
    }

    private void initialize() {
        File confLocation = null;
        confLocation = JavaAgent.getInstance() == null ? JavaAgentUtil.getAgentInstallDirectory() : JavaAgent.getInstance().getAgentConfig().getInstanceDir();
        try {
            this.debugConfigProps = Utils.getContentAsProps(new File(confLocation, "debug_mode.conf"));
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "Unable to read contents from debug_mode.conf file.", th);
            this.debugConfigProps = new Properties();
        }
        try {
            int duration = Integer.parseInt(this.debugConfigProps.getProperty("agent.debug.duration"));
            if (duration == -1) {
                this.debugModeDuration = Integer.MAX_VALUE;
            }
            this.debugModeDuration = duration * 60;
        }
        catch (Throwable th) {
            this.debugModeDuration = 7200;
        }
        try {
            File props = new File(confLocation, "key_transactions.conf");
            AgentDebugModeConfig.initializeSequenceFilter(props);
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "Unable to read contents from key_transactions.conf file.", th);
        }
        JavaAgent.logger.info("Debug mode configurations initialized.");
    }

    public static void initializeSequenceFilter(File props) {
        if (!props.exists()) {
            return;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(props));
            StringBuilder sb = new StringBuilder("");
            int count = 0;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.length() == 0) continue;
                if (++count > 10) {
                    JavaAgent.logger.warn("[KEY_TRANSACTION] Too many transactions provided. Only 10 transactions are allowed at maximum");
                    break;
                }
                sb.append('|');
                sb.append(line.replaceAll("\\s+", ""));
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(0);
            }
            br.close();
            regex = Pattern.compile(sb.toString());
            JavaAgent.logger.info("[KEY_TRANSACTION] Initialized with following value \"" + regex.pattern() + "\"");
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Error Occurred during SequenceFilterByName initialization. " + th);
            regex = Pattern.compile("");
        }
    }

    public static boolean isSkip(String url) {
        if (regex == null) {
            return false;
        }
        return !Pattern.matches(regex.pattern(), url);
    }

    public void reinitialize() {
        JavaAgent.logger.log(Level.INFO, "Reinitializing Configuration changes for agent DEBUG mode");
        this.initialize();
    }

    public Properties getConfig() {
        return this.debugConfigProps;
    }

    public int getDebugModeDuration() {
        return this.debugModeDuration;
    }
}

