/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.config;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.JavaAgentConstants;
import com.manageengine.apminsight.agent.jvm.EnvironmentIdentifier;
import com.manageengine.apminsight.agent.jvm.HostEnvIdentifier;
import com.manageengine.apminsight.agent.util.HostNameUtil;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.apminsight.agent.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;

public class AppNameDetector
implements JavaAgentConstants {
    private static Map<String, String> identifiedTags = new HashMap<String, String>();

    public static String identifyAppName() {
        String identifiedAppName = AppNameDetector.getAppNameFromEnvs();
        if (!StringUtils.isEmptyString(identifiedAppName)) {
            return identifiedAppName;
        }
        identifiedAppName = AppNameDetector.getAppNamefromFrameworks();
        if (!StringUtils.isEmptyString(identifiedAppName)) {
            return identifiedAppName;
        }
        return "";
    }

    private static String getAppNameFromEnvs() {
        String envAppName = "";
        if (HostEnvIdentifier.getActualHostType().equals("KUBERNETES")) {
            String podName = System.getenv("HOSTNAME");
            ArrayList<Integer> hyphenIndices = new ArrayList<Integer>();
            for (int i = 0; i < podName.length(); ++i) {
                if (podName.charAt(i) != '-') continue;
                hyphenIndices.add(i);
            }
            envAppName = hyphenIndices.size() <= 2 ? podName : podName.substring(0, (Integer)hyphenIndices.get(hyphenIndices.size() - 2));
        } else if (HostEnvIdentifier.getActualHostType().equals("AZURE")) {
            envAppName = System.getenv("APPSETTING_WEBSITE_SITE_NAME");
            envAppName = envAppName != null ? envAppName : System.getenv("WEBSITE_SITE_NAME");
        } else if (HostEnvIdentifier.getActualHostType().equals("OPENSHIFT")) {
            envAppName = System.getenv("KUBERNETES_DEPLOYMENT_NAME");
        } else if (System.getenv("EB_APPLICATION_NAME") != null) {
            envAppName = System.getenv("EB_APPLICATION_NAME");
        }
        return envAppName;
    }

    public static String getAppNameFromAppServer() {
        String appServer = EnvironmentIdentifier.getAppServer().toString();
        if (!appServer.equals("UNKNOWN")) {
            appServer = Character.toUpperCase(appServer.charAt(0)) + appServer.substring(1).toLowerCase();
            return appServer + "Application";
        }
        return "";
    }

    private static String getAppNamefromFrameworks() {
        String jvmStartCommand;
        StringBuilder frameAppName = new StringBuilder();
        frameAppName.append(System.getProperty("spring.application.name", ""));
        if (StringUtils.isEmptyString(frameAppName.toString()) && !StringUtils.isEmptyString(jvmStartCommand = System.getProperty("sun.java.command"))) {
            for (String s : jvmStartCommand.split(" ")) {
                if (!s.endsWith(".jar")) continue;
                HashSet<String> releaseTypes = new HashSet<String>(Arrays.asList("snapshot", "release", "final", "alpha", "beta", "rc", "patch"));
                s = s.substring(0, s.length() - 4);
                int lastHiphen = s.lastIndexOf(45);
                frameAppName.append(s.substring(0, lastHiphen));
                String possiblyType = s.substring(lastHiphen + 1);
                if (JavaAgent.getInstance().agentConfig.canIdentifyTags() && releaseTypes.contains(possiblyType.toLowerCase())) {
                    identifiedTags.putIfAbsent("profile", possiblyType);
                } else {
                    frameAppName.append("-" + possiblyType);
                }
                return frameAppName.toString().replaceAll("[/\\\\]", "_");
            }
        }
        return frameAppName.toString();
    }

    public static void setAppNamefromReqURL(String domainfromreqURL) {
        if (StringUtils.isEmptyString(JavaAgent.getInstance().agentConfig.getApplicationName())) {
            if (AppNameDetector.isValidDomain(domainfromreqURL)) {
                JavaAgent.getInstance().agentConfig.setApplicationName(domainfromreqURL);
            } else {
                String namefromAppServer = AppNameDetector.getAppNameFromAppServer();
                if (!StringUtils.isEmptyString(namefromAppServer)) {
                    JavaAgent.getInstance().agentConfig.setApplicationName(namefromAppServer);
                } else {
                    JavaAgent.getInstance().agentConfig.setApplicationName("My Application_" + UUIDGenerator.generateSpanID().substring(0, 4));
                }
            }
        }
    }

    public static boolean isValidDomain(String domain) {
        String ipPattern = "^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$";
        return !Pattern.compile(ipPattern).matcher(domain).matches() && !domain.equalsIgnoreCase("localhost") && !domain.equalsIgnoreCase(HostNameUtil.getActualHostname()) && !domain.equalsIgnoreCase(HostNameUtil.getFQDN());
    }

    public static void addMonitorTagsfromSysProps() {
        String identifiedProfile = System.getProperty("spring.profiles.active", "");
        if (!StringUtils.isEmptyString(identifiedProfile)) {
            identifiedTags.put("profile", identifiedProfile);
        }
    }

    public static Map<String, String> getIdentifiedTags() {
        return identifiedTags;
    }
}

